/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileExifIFD
extends TiffProfile {
    private static final String[] ACCEPTED_EXIF_VERSIONS = new String[]{"0200", "0210", "0220", "0221", "0230"};
    private int _majVersion;
    private int _minVersion;

    public TiffProfileExifIFD() {
        this._profileText = null;
        this._majVersion = -1;
        this._minVersion = -1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof ExifIFD)) {
            return false;
        }
        ExifIFD eifd = (ExifIFD)ifd;
        String version = eifd.getExifVersion();
        for (String acceptedVersion : ACCEPTED_EXIF_VERSIONS) {
            if (!acceptedVersion.equals(version)) continue;
            this._majVersion = Integer.parseInt(version.substring(0, 2));
            this._minVersion = Integer.parseInt(version.substring(2, 4));
            break;
        }
        if (this._majVersion == -1) {
            return false;
        }
        if (!"0100".equals(eifd.getFlashpixVersion())) {
            return false;
        }
        int colspc = eifd.getColorspace();
        return colspc == 1 || colspc == 65535;
    }

    public int getMajorVersion() {
        return this._majVersion;
    }

    public int getMinorVersion() {
        return this._minVersion;
    }
}

