DROP TABLE IF EXISTS INGEST_TRACKING_RECORD_FEEDER;
CREATE TABLE INGEST_TRACKING_RECORD_FEEDER 
(
  WORKFLOW_EXECUTION_ID VARCHAR(128) NOT NULL 
, WORKSPACE_ID VARCHAR(128) NOT NULL 
, WORKSPACE_PATH VARCHAR(255) NOT NULL 
/*, WORKSPACE_PATH VARCHAR(4000) NOT NULL */ 
, SUBMIT_TIMESTAMP DATE NOT NULL 
, SOURCE_PATH VARCHAR(4000) NOT NULL 
, CREATE_DT DATE NOT NULL 
, UPDATE_DT DATE NOT NULL 
, SIP_PATH VARCHAR(255) 
/*, SIP_PATH VARCHAR(1024) */
, SIP_TYPE VARCHAR(128) NOT NULL 
, IE_DIGEST VARCHAR(128) 
, SIP_ID VARCHAR(128) 
, ARCH_PATH VARCHAR(1024) 
, SIP_STATUS VARCHAR(128) NOT NULL 
, AMD_ID VARCHAR(20) NOT NULL 
, SIP_NAME VARCHAR(255) NOT NULL 
/*, SIP_NAME VARCHAR(1024) NOT NULL */
, ENTITY_ID VARCHAR(128) 
, INGEST_ID VARCHAR(128) 
, DOI VARCHAR(50)
, CONSTRAINT DOI_UNIQUE UNIQUE (DOI) 
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE INDEX IDX_01_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (SIP_STATUS ASC);
CREATE UNIQUE INDEX IDX_U01_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (SIP_TYPE ASC, SIP_PATH ASC, IE_DIGEST ASC);
CREATE UNIQUE INDEX IDX_U02_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (WORKSPACE_ID ASC, WORKSPACE_PATH ASC, SUBMIT_TIMESTAMP ASC);
CREATE UNIQUE INDEX IDX_U03_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (WORKSPACE_ID ASC, SIP_NAME ASC, AMD_ID ASC);
