/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.premis;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.premis.EventOutcome;
import ch.docuteam.darc.premis.EventType;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.string.DateFormatter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class Event
extends NodeAbstract {
    private static final String IDType = "Docuteam";
    private static final String PerformedBy = "Performed by: '" + OperatingSystem.userName() + "'";
    protected String idType = "Docuteam";
    protected EventType type = null;
    protected String dateTime = "";
    protected String detail = "";
    protected EventOutcome outcome = null;
    protected String outcomeDetail = "";
    protected String linkingObjectIdType = "Docuteam";
    protected String linkingObjectIdValue = "";

    public Event(DigiprovWithPremis parent, Element parentElement, String linkObjectId, String date, String type, String detail, String outcome, String outcomeDetail) {
        if (linkObjectId == null) {
            Exception.remember((String)"new Event: LinkObjectId must not be null");
        }
        if (type == null) {
            Exception.remember((String)"new Event: type must not be null");
        }
        if (detail == null) {
            Exception.remember((String)"new Event: detail must not be null");
        }
        if (outcome == null) {
            Exception.remember((String)"new Event: outcome must not be null");
        }
        if (date == null) {
            date = DateFormatter.getCurrentDateTimeString();
        }
        this.parent = parent;
        this.document = parent.getDocument();
        this.id = UniqueID.getXML();
        this.type = EventType.get(type);
        this.dateTime = date;
        this.detail = detail == null || detail.trim().isEmpty() ? PerformedBy : detail + ". " + PerformedBy;
        this.outcome = EventOutcome.get(outcome);
        this.outcomeDetail = outcomeDetail;
        this.linkingObjectIdValue = linkObjectId;
        this.element = parentElement.addElement("PREMIS:event");
        Element eventIdentifier = this.element.addElement("PREMIS:eventIdentifier");
        eventIdentifier.addElement("PREMIS:eventIdentifierType").addText(this.idType);
        eventIdentifier.addElement("PREMIS:eventIdentifierValue").addText(this.id);
        this.element.addElement("PREMIS:eventType").addText(this.getType());
        this.element.addElement("PREMIS:eventDateTime").addText(this.dateTime);
        this.element.addElement("PREMIS:eventDetail").addText(this.detail);
        Element eventOutcomeInformation = this.element.addElement("PREMIS:eventOutcomeInformation");
        eventOutcomeInformation.addElement("PREMIS:eventOutcome").addText(this.outcome.getValue());
        if (!this.outcomeDetail.isEmpty()) {
            eventOutcomeInformation.addElement("PREMIS:eventOutcomeDetail").addElement("PREMIS:eventOutcomeDetailNote").addText(this.outcomeDetail);
        }
        Element linkingObjectIdentifier = this.element.addElement("PREMIS:linkingObjectIdentifier").addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink").addAttribute("xlink:type", "simple");
        linkingObjectIdentifier.addElement("PREMIS:linkingObjectIdentifierType").addText(this.linkingObjectIdType);
        linkingObjectIdentifier.addElement("PREMIS:linkingObjectIdentifierValue").addText(this.linkingObjectIdValue);
    }

    private Event(DigiprovWithPremis parent, Element eventElement) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = eventElement;
        this.idType = this.getElementText("./PREMIS:eventIdentifier/PREMIS:eventIdentifierType", true);
        this.id = this.getElementText("./PREMIS:eventIdentifier/PREMIS:eventIdentifierValue", true);
        this.type = EventType.get(this.getElementText("./PREMIS:eventType", true));
        this.dateTime = this.getElementText("./PREMIS:eventDateTime", true);
        this.detail = this.getElementText("./PREMIS:eventDetail", false);
        this.outcome = EventOutcome.get(this.getElementText("./PREMIS:eventOutcomeInformation/PREMIS:eventOutcome", true));
        this.outcomeDetail = this.getElementText("./PREMIS:eventOutcomeInformation/PREMIS:eventOutcomeDetail/PREMIS:eventOutcomeDetailNote", false);
        this.linkingObjectIdType = this.getElementText("./PREMIS:linkingObjectIdentifier/PREMIS:linkingObjectIdentifierType", true);
        this.linkingObjectIdValue = this.getElementText("./PREMIS:linkingObjectIdentifier/PREMIS:linkingObjectIdentifierValue", true);
    }

    public static List<Event> parse(DigiprovWithPremis parent, Element premisElement) {
        ArrayList<Event> fileList = new ArrayList<Event>();
        for (java.lang.Object o : premisElement.selectNodes("./PREMIS:event")) {
            fileList.add(new Event(parent, (Element)o));
        }
        return fileList;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getType() {
        if (this.type == null) {
            return "";
        }
        return this.type.getValue();
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getOutcome() {
        if (this.outcome == null) {
            return "";
        }
        return this.outcome.getValue();
    }

    public String getOutcomeDetail() {
        return this.outcomeDetail;
    }

    public String getLinkingObjectIdType() {
        return this.linkingObjectIdType;
    }

    public String getLinkingObjectIdValue() {
        return this.linkingObjectIdValue;
    }

    public Object getLinkedObject() {
        return ((DigiprovWithPremis)this.parent).getObject(this.linkingObjectIdValue);
    }

    public String toString() {
        return "[PREMISEvent:id=" + this.id + "/Object->" + this.linkingObjectIdValue + "(" + this.dateTime + "/" + this.getType() + "/" + this.detail + "/" + this.getOutcome() + "/" + this.outcomeDetail + "]";
    }
}

