/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.LinkedList;
import java.util.ListIterator;

public class HtmlStack
extends LinkedList {
    private HtmlTagDesc headElement;
    private HtmlTagDesc bodyElement;
    private HtmlTagDesc framesetElement;
    private boolean headSeen;
    private boolean bodySeen;

    protected void setHeadElement(HtmlTagDesc elem) {
        this.headElement = elem;
    }

    protected void setBodyElement(HtmlTagDesc elem) {
        this.bodyElement = elem;
    }

    protected void setFramesetElement(HtmlTagDesc elem) {
        this.bodyElement = elem;
    }

    protected void popp() {
        this.removeLast();
    }

    @Override
    protected void push(JHOpenTag tag) {
        this.add(tag);
        HtmlTagDesc element = tag.getElement();
        if (element == this.headElement) {
            this.headSeen = true;
        } else if (element == this.bodyElement) {
            this.bodySeen = true;
        }
    }

    protected JHOpenTag top() {
        return (JHOpenTag)this.getLast();
    }

    protected int search(String tag) {
        ListIterator liter = this.listIterator(this.size());
        int idx = this.size() - 1;
        while (liter.hasPrevious()) {
            JHOpenTag stackTag = (JHOpenTag)liter.previous();
            HtmlTagDesc elem = stackTag.getElement();
            if (elem.matches(tag)) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    protected void popTo(int idx) {
        int npop = this.size() - idx;
        for (int i = 0; i < npop; ++i) {
            this.removeLast();
        }
    }

    protected boolean isHeadSeen() {
        return this.headSeen;
    }

    protected boolean isBodySeen() {
        return this.bodySeen;
    }

    protected boolean excludesTag(String tag) {
        for (JHOpenTag stackTag : this) {
            if (!stackTag.getElement().excludesTag(tag)) continue;
            return true;
        }
        return false;
    }
}

