/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ChannelDefBox
extends JP2Box {
    public ChannelDefBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof CodestreamHeaderBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        int nchan = this._module.readUnsignedShort(this._dstrm);
        len -= 2;
        Property[] chans = new Property[nchan];
        for (int i = 0; i < nchan; ++i) {
            Property[] cprop = new Property[3];
            int cidx = this._module.readUnsignedShort(this._dstrm);
            cprop[0] = new Property("ChannelIndex", PropertyType.INTEGER, (Object)new Integer(cidx));
            int typ = this._module.readUnsignedShort(this._dstrm);
            cprop[1] = this._module.addIntegerProperty("ChannelType", typ, JP2Strings.ctypStr, JP2Strings.ctypIdx);
            int assoc = this._module.readUnsignedShort(this._dstrm);
            len -= 6;
            cprop[2] = new Property("ChannelAssociation", PropertyType.INTEGER, (Object)new Integer(assoc));
            chans[i] = new Property("Channel", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)cprop);
        }
        this._module.skipBytes(this._dstrm, len, this._module);
        Property prop = new Property("ChannelDefinition", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)chans);
        if (this._parentBox instanceof JP2HeaderBox) {
            this._module.addProperty(prop);
        } else if (this._parentBox instanceof ComposLayerHdrBox) {
            ((ComposLayerHdrBox)this._parentBox).addChannelDef(prop);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Channel Definition Box";
    }
}

