/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorSpecBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JP2HeaderBox
extends JP2Box {
    public JP2HeaderBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        Property a;
        this.initBytesRead();
        this.hasBoxes = true;
        if (this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage("Multiple JP2 Header Boxes not allowed", this._module.getFilePos()));
            this._repInfo.setValid(false);
            if (this._boxHeader.getLength() != 0L) {
                this._module.skipBytes(this._dstrm, (int)this._boxHeader.getDataLength(), this._module);
            }
        }
        this._module.setJP2HdrSeen(true);
        if (this._module.getNCodestreams() > 0) {
            this._module.setJP2Compliant(false);
        }
        int state = 0;
        JP2Box box = null;
        boolean hasCMap = false;
        boolean hasPalette = false;
        while (this.hasNext()) {
            box = (JP2Box)this.next();
            if (state == 0 && box instanceof LabelBox) {
                state = 1;
                this._module.setJP2Compliant(false);
                if (!box.readBox()) {
                    return false;
                }
                this._module.addProperty(new Property("JP2HeaderLabel", PropertyType.STRING, (Object)((LabelBox)box).getLabel()));
                box = (JP2Box)this.next();
                continue;
            }
            if (state <= 1) {
                if (box instanceof ImageHeaderBox) {
                    state = 2;
                    if (box.readBox()) continue;
                    return false;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("First box of JP2 header must be image header", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            if (box instanceof AssociationBox || box instanceof BPCCBox || box instanceof ColorSpecBox || box instanceof PaletteBox || box instanceof ComponentMapBox || box instanceof ChannelDefBox || box instanceof ResolutionBox || box instanceof ROIBox) {
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        if (hasCMap && !hasPalette) {
            this._repInfo.setMessage((Message)new ErrorMessage("JP2 Header has Component Mapping box without Palette Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        if (!hasCMap && hasPalette) {
            this._repInfo.setMessage((Message)new ErrorMessage("JP2 Header has Palette box without Component Mapping Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        if ((a = this.makeAssocProperty()) != null) {
            this._module.addProperty(a);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "JP2 Header Box";
    }
}

