/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.XProfileBase;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public final class X3Profile
extends XProfileBase {
    public X3Profile(PdfModule module) {
        super(module, XProfileBase.PDFX3);
        this._profileText = "ISO PDF/X-3";
    }

    @Override
    public boolean satisfiesThisProfile() {
        try {
            PdfDictionary catDict = this._module.getCatalogDict();
            PdfArray intentsArray = (PdfArray)this._module.resolveIndirectObject(catDict.get("OutputIntents"));
            if (intentsArray == null) {
                return false;
            }
            if (!this.infoDictOK("PDF/X-3")) {
                return false;
            }
            if (!this.outputIntentsOK(intentsArray)) {
                return false;
            }
            if (!this.resourcesOK()) {
                return false;
            }
            if (!this.trailerDictOK()) {
                return false;
            }
            if (this._module.getEncryptionDict() != null) {
                return false;
            }
            if (!this.bboxOK(false)) {
                return false;
            }
            if (this._module.getActionsExist()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean resourcesOK() {
        PageTreeNode docTreeRoot = this._module.getDocumentTree();
        try {
            DocNode docNode;
            docTreeRoot.startWalk();
            while ((docNode = docTreeRoot.nextDocNode()) != null) {
                PdfArray annots;
                PdfDictionary rsrc = docNode.getResources();
                if (rsrc != null) {
                    PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("ExtGState"));
                    if (!this.extGStateOK(gs)) {
                        return false;
                    }
                    PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("XObject"));
                    if (!this.xObjectsOK(xo)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                List streams = ((PageObject)docNode).getContentStreams();
                if (streams != null) {
                    ListIterator iter = streams.listIterator();
                    while (iter.hasNext()) {
                        PdfObject filters;
                        PdfStream stream = (PdfStream)iter.next();
                        PdfDictionary dict = stream.getDict();
                        PdfDictionary rs = (PdfDictionary)dict.get("Resources");
                        if (rs != null) {
                            PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rs.get("ExtGState"));
                            if (!this.extGStateOK(gs)) {
                                return false;
                            }
                            PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rs.get("XObject"));
                            if (!this.xObjectsOK(xo)) {
                                return false;
                            }
                        }
                        if (!this.filterOK(filters = dict.get("Filter"), true, true)) {
                            return false;
                        }
                        if (dict.get("F") == null) continue;
                        return false;
                    }
                }
                if ((annots = ((PageObject)docNode).getAnnotations()) == null) continue;
                Vector<PdfObject> annVec = annots.getContent();
                for (int i = 0; i < annVec.size(); ++i) {
                    Vector<PdfObject> ffVec;
                    PdfArray ff;
                    PdfDictionary annDict = (PdfDictionary)this._module.resolveIndirectObject(annVec.elementAt(i));
                    PdfSimpleObject subtypeObj = (PdfSimpleObject)annDict.get("Subtype");
                    if (!"TrapNet".equals(subtypeObj.getStringValue()) || (ff = (PdfArray)annDict.get("FontFauxing")) == null || (ffVec = ff.getContent()).size() <= 0) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary xo) {
        if (xo == null) {
            return true;
        }
        if (!super.xObjectOK(xo)) {
            return false;
        }
        return xo.get("OPI") == null;
    }
}

