/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITSD
extends TiffProfileClassIT {
    public TiffProfileClassITSD() {
        this._profileText = "TIFF/IT-SD (ISO 12639:2003)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps[0] != 1) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{1, 4})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 4, 8})) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tifd, 2)) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        if (inkSet != 1) {
            return false;
        }
        String seq = tifd.getColorSequence();
        return seq == null || "CMYK".equals(seq) || "YMCK".equals(seq);
    }
}

