/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXC
extends TiffFXBase {
    public TiffProfileFXC() {
        this._profileText = "TIFF-FX (Profile C)";
        this._mimeClass = 1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        int bps;
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesClass(tifd)) {
            return false;
        }
        if (!this.satisfiesImageWidth(tifd, new int[]{864, 1024, 1216, 1728, 2048, 2432, 2592, 3072, 3456, 3648, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{1, 3})) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 7)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 10)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3, -1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{1, 3})) {
            return false;
        }
        if (!this.satisfiesXResolution(tifd, new int[]{100, 200, 300, 400})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tifd, new int[]{1, 2})) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        long xRes = niso.getXSamplingFrequency().toLong();
        if (xRes != niso.getYSamplingFrequency().toLong()) {
            return false;
        }
        if (niso.getSamplingFrequencyUnit() == 3) {
            xRes = this.perCMtoPerInch((int)xRes);
        }
        if ((bps = niso.getBitsPerSample()[0]) != 8 && bps != 12) {
            return false;
        }
        int wid = (int)niso.getImageWidth();
        switch ((int)xRes) {
            case 100: {
                if (wid == 864 || !(wid != 1024 & wid != 1216)) break;
                return false;
            }
            case 200: {
                if (wid == 1728 || !(wid != 2048 & wid != 2432)) break;
                return false;
            }
            case 300: {
                if (wid == 2592 || !(wid != 3072 & wid != 3648)) break;
                return false;
            }
            case 400: {
                if (wid == 3456 || !(wid != 4096 & wid != 4864)) break;
                return false;
            }
        }
        return tifd.getIndexed() != 1 || niso.getColormapRedValue() != null;
    }
}

