/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

public class TiffTags {
    private static final String[] TAG_LABELS = new String[]{"NewSubFileType", "SubFileType", "ImageWidth", "ImageLength", "BitsPerSample", "Compression", "PhotometricInterpretation", "Thresholding", "CellWidth", "CellLength", "FillOrder", "DocumentName", "ImageDescription", "Make", "Model", "StripOffsets", "Orientation", "SamplesPerPixel", "RowsPerStrip", "StripByteCounts", "MinSampleValue", "MaxSampleValue", "XResolution", "YResolution", "PlanarConfiguration", "PageName", "XPosition", "YPosition", "FreeOffsets", "FreeByteCounts", "GrayResponseUnit", "GrayResponseCurve", "Group3Options", "Group4Options", "ResolutionUnit", "PageNumber", "ColorResponseUnit", "TransferFunction", "Software", "DateTime", "Artist", "HostComputer", "Predictor", "WhitePoint", "PrimaryChromacities", "ColorMap", "HalftoneHints", "TileWidth", "TileLength", "TileOffsets", "TileByteCounts", "BadFaxLines", "CleanFaxData", "ConsecutiveBadFaxLines", "SubIFDs", "InkSet", "InkNames", "NumberOfInks", "DotRange", "TargetPrinter", "ExtraSamples", "SampleFormat", "SMinSampleValue", "SMaxSampleValue", "TransferRange", "ClipPath", "XClipPathUnits", "YClipPathUnits", "Indexed", "JPEGTables", "OPIProxy", "GlobalParametersIFD", "ProfileType", "FaxProfile", "CodingMethods", "VersionYear", "ModeNumber", "JPEGProc", "JPEGInterchangeFormat", "JPEGInterchangeFormatLength", "JPEGRestartInterval", "JPEGLosslessPredictors", "JPEGPointTransforms", "JPEGQTables", "JPEGDCTables", "JPEGACTables", "YCbCrCoefficients", "YCbCrSubsampling", "YCbCrPositioning", "ReferenceBlackWhite", "StripRowCounts", "ImageID", "Matteing", "DataType", "ImageDepth", "TileDepth", "CFARepeatPatternDim", "CFAPattern", "BatteryLevel", "Copyright", "ExposureTime", "Fnumber", "IPTC/NAA", "ModelPixelScaleTag", "IntergraphMatrixTag", "ModelTiepointTag", "Site", "ColorSequence", "IT8Header", "RasterPadding", "BitsPerRunLength", "BitsPerExtendedRunLength", "ColorTable", "ImageColorIndicator", "BackgroundColorIndicator", "ImageColorValue", "BackgroundColorValue", "PixelInensityRange", "TransparencyIndicator", "ColorCharacterization", "HCUsage", "ModelTransformationTag", "ImageResources", "ExifIFD", "ICCProfile", "ImageLayer", "GeoKeyDirectoryTag", "GeoDoubleParamsTag", "GeoAsciiParamsTag", "ExposureProgram", "SpectralSensitivity", "GPSInfo", "ISOSpeedRatings", "OECF", "Interlace", "TimeZoneOffset", "SelfTimerMode", "FaxRecvParams", "FaxSubAddress", "FaxRecvTime", "DateTimeOriginal", "CompressedBitsPerPixel", "ShutterSpeedValue", "ApertureValue", "BrightnessValue", "ExposureBiasValue", "MaxApertureValue", "SubjectDistance", "MeteringMode", "LightSource", "Flash", "FocalLength", "FlashEnergy", "SpatialFrequencyResponse", "Noise", "FocalPlaneXResolution", "FocalPlaneYResolution", "FocalPlaneResolutionUnit", "ImageNumber", "SecurityClassification", "ImageHistory", "SubjectLocation", "ExposureIndex", "TIFF/EPStandardID", "SensingMethod", "StoNits", "ImageSourceData", "InteroperabilityIFD", "Annotations", "DNGVersion", "DNGBackwardVersion", "UniqueCameraModel", "LocalizedCameraModel", "CFAPlaneColor", "CFALayout", "LinearizationTable", "BlackLevelRepeatDim", "BlackLevel", "BlackLevelDeltaH", "BlackLevelDeltaV", "WhiteLevel", "DefaultScale", "DefaultCropOrigin", "DefaultCropSize", "ColorMatrix1", "ColorMatrix2", "CameraCalibration1", "CameraCalibration2", "ReductionMatrix1", "ReductionMatrix2", "AnalogBalance", "AsShotNeutral", "AsShotWhiteXY", "BaselineExposure", "BaselineNoise", "BaselineSharpness", "BayerGreenSplit", "LinearResponseLimit", "CameraSerialNumber", "LensInfo", "ChromaBlurRadius", "AntiAliasStrength", "ShadowScale", "DNGPrivateData", "MakerNoteSafety", "CalibrationIlluminant1", "CalibrationIlluminant2", "BestQualityScale"};
    private static final int[] TAG_INDEX = new int[]{254, 255, 256, 257, 258, 259, 262, 263, 264, 265, 266, 269, 270, 271, 272, 273, 274, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 296, 297, 300, 301, 305, 306, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 330, 332, 333, 334, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 351, 400, 401, 402, 403, 404, 405, 512, 513, 514, 515, 517, 518, 519, 520, 521, 529, 530, 531, 532, 559, 32781, 32995, 32996, 32997, 32998, 33421, 33422, 33423, 33432, 33434, 33437, 33723, 33550, 33920, 33922, 34016, 34017, 34018, 34019, 34020, 34021, 34022, 34023, 34024, 34025, 34026, 34027, 34028, 34029, 34030, 34264, 34377, 34665, 34675, 34732, 34735, 34736, 34737, 34850, 34852, 34853, 34855, 34856, 34857, 34858, 34859, 34908, 34909, 34910, 36867, 37122, 37377, 37378, 37379, 37380, 37381, 37382, 37383, 37384, 37385, 37386, 37387, 37388, 37389, 37390, 37391, 37392, 37393, 37394, 37395, 37396, 37397, 37398, 37399, 37439, 37724, 40965, 50255, 50706, 50707, 50708, 50709, 50710, 50711, 50712, 50713, 50714, 50715, 50716, 50717, 50718, 50719, 50720, 50721, 50722, 50723, 50724, 50725, 50726, 50727, 50728, 50729, 50730, 50731, 50732, 50733, 50734, 50735, 50736, 50737, 50738, 50739, 50740, 50741, 50778, 50779, 50780};

    private TiffTags() {
    }

    public static String tagName(int tag) {
        if (TAG_INDEX.length != TAG_LABELS.length) {
            // empty if block
        }
        String name = null;
        int n = -1;
        for (int i = 0; i < TAG_INDEX.length; ++i) {
            if (tag != TAG_INDEX[i]) continue;
            n = i;
            break;
        }
        name = n > -1 ? TAG_LABELS[n] : Integer.toString(tag);
        return name;
    }
}

