/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.zip;

import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import uk.gov.nationalarchives.droid.container.AbstractIdentifierEngine;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.archive.TrueZipReader;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;

public class ZipIdentifierEngine
extends AbstractIdentifierEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(IdentificationRequest request, ContainerSignatureMatchCollection matches) throws IOException {
        try (ZipFile zipFile = new ZipFile((ReadOnlyFile)new TrueZipReader(request.getWindowReader()), ZipFile.DEFAULT_CHARSET, true, false);){
            for (String entryName : matches.getAllFileEntries()) {
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry == null) continue;
                InputStream stream = zipFile.getInputStream(entry);
                ByteReader reader = null;
                try {
                    reader = this.newByteReader(stream);
                    List<ContainerSignatureMatch> matchList = matches.getContainerSignatureMatches();
                    for (ContainerSignatureMatch match : matchList) {
                        match.matchBinaryContent(entryName, reader);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
    }
}

