/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public abstract class FileChecksumCalculator {
    public static String getMD5(String filePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Algorithm.MD5.getDigest(filePath);
    }

    public static String getCRC32(String filePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Algorithm.CRC32.getDigest(filePath);
    }

    public static String getSHA1(String filePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Algorithm.SHA1.getDigest(filePath);
    }

    public static String getSHA256(String filePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Algorithm.SHA256.getDigest(filePath);
    }

    public static String getSHA512(String filePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Algorithm.SHA512.getDigest(filePath);
    }

    public static enum Algorithm {
        CRC32,
        MD5,
        SHA1,
        SHA256,
        SHA512;


        public static Algorithm lookup(String name) throws NoSuchAlgorithmException {
            Algorithm[] algorithms;
            for (Algorithm algorithm : algorithms = Algorithm.values()) {
                if (!algorithm.getCode().equals(name)) continue;
                return algorithm;
            }
            throw new NoSuchAlgorithmException();
        }

        public String getDigest(String filePath) throws IOException, NoSuchAlgorithmException {
            switch (this) {
                case CRC32: {
                    return this.getChecksumZip(filePath);
                }
            }
            return this.getChecksum(filePath);
        }

        public String getCode() {
            switch (this) {
                case CRC32: {
                    return "CRC-32";
                }
                case MD5: {
                    return "MD5";
                }
                case SHA1: {
                    return "SHA-1";
                }
                case SHA256: {
                    return "SHA-256";
                }
                case SHA512: {
                    return "SHA-512";
                }
            }
            throw new RuntimeException("Invalid algorithm");
        }

        private String getChecksumZip(String filePath) throws IOException {
            CRC32 checksum = new CRC32();
            String result = null;
            try (FileInputStream is = new FileInputStream(filePath);){
                int bytesRead;
                byte[] bytes = new byte[65536];
                while ((bytesRead = ((InputStream)is).read(bytes)) != -1) {
                    checksum.update(bytes, 0, bytesRead);
                }
            }
            long value = checksum.getValue();
            result = String.format("%08X", value).toLowerCase();
            return result;
        }

        private String getChecksum(String filePath) throws IOException, NoSuchAlgorithmException {
            MessageDigest md = MessageDigest.getInstance(this.getCode());
            String result = null;
            try (FileInputStream is = new FileInputStream(filePath);){
                int bytesRead;
                byte[] bytes = new byte[65536];
                while ((bytesRead = ((InputStream)is).read(bytes)) != -1) {
                    md.update(bytes, 0, bytesRead);
                }
                byte[] digestBytes = md.digest();
                StringBuffer sb = new StringBuffer();
                for (byte b : digestBytes) {
                    sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
                }
                result = sb.toString();
            }
            return result;
        }
    }
}

