/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.util;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildInfoUtil {
    private static final String BUILD_PROPERTIES_FILE = "/build.properties";
    private final Properties pomProperties;

    public BuildInfoUtil() {
        block9: {
            this.pomProperties = new Properties();
            try (InputStream inStream = ResourceUtil.getResourceAsStream(BUILD_PROPERTIES_FILE);){
                if (inStream != null) {
                    this.pomProperties.load(inStream);
                    break block9;
                }
                throw new FileNotFoundException("property file /build.properties not found in the classpath");
            }
            catch (IOException e) {
                Logger.error("errr at loading property file: /build.properties", e);
            }
        }
    }

    public String getVersion() {
        return this.pomProperties.getProperty("build.version");
    }

    public String getLastChange() {
        return this.pomProperties.getProperty("build.date");
    }

    public String getProduct() {
        return this.pomProperties.getProperty("build.artifactId");
    }

    public Properties getBuildProperties() {
        return this.pomProperties;
    }

    public static void main(String[] args) throws Exception {
        BuildInfoUtil buildInfo = new BuildInfoUtil();
        Logger.info("product: " + buildInfo.getProduct());
        Logger.info("version: " + buildInfo.getVersion());
        Logger.info("last changed: " + buildInfo.getLastChange());
    }
}

