/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

public class FontUtil {
    private static final String AWT_STYLE_BOLD_ITAL = "boldital";
    private static final String AWT_STYLE_DEMI_ITAL = "demiital";
    private static final String AWT_STYLE_ITAL = "ital";
    private static final String AWT_STYLE_OBLI = "obli";
    private static final String STYLE_BOLD_ITALIC = "bolditalic";
    private static final String STYLE_DEMI_ITALIC = "demiitalic";
    private static final String STYLE_BOLD = "bold";
    private static final String STYLE_DEMI = "demi";
    private static final String STYLE_ITALIC = "italic";
    private static final String STYLE_BLACK = "black";

    public static int guessAWTFontStyle(String name) {
        name = name.toLowerCase();
        int decorations = 0;
        decorations = name.indexOf(AWT_STYLE_BOLD_ITAL) > 0 || name.indexOf(AWT_STYLE_DEMI_ITAL) > 0 ? (decorations |= 3) : (name.indexOf(STYLE_BOLD) > 0 || name.indexOf(STYLE_BLACK) > 0 || name.indexOf(STYLE_DEMI) > 0 ? (decorations |= 1) : (name.indexOf(AWT_STYLE_ITAL) > 0 || name.indexOf(AWT_STYLE_OBLI) > 0 ? (decorations |= 2) : (decorations |= 0)));
        return decorations;
    }

    public static String guessFamily(String name) {
        String fam = name;
        int inx = fam.indexOf(44);
        if (inx > 0) {
            fam = fam.substring(0, inx);
        }
        if ((inx = fam.lastIndexOf(45)) > 0) {
            fam = fam.substring(0, inx);
        }
        if ((inx = fam.toLowerCase().lastIndexOf(STYLE_BOLD_ITALIC)) > 0) {
            fam = fam.substring(0, inx);
        } else {
            inx = fam.toLowerCase().lastIndexOf(STYLE_DEMI_ITALIC);
            if (inx > 0) {
                fam = fam.substring(0, inx);
            } else {
                inx = fam.toLowerCase().lastIndexOf(STYLE_BOLD);
                if (inx > 0) {
                    fam = fam.substring(0, inx);
                } else {
                    inx = fam.toLowerCase().lastIndexOf(STYLE_ITALIC);
                    if (inx > 0) {
                        fam = fam.substring(0, inx);
                    } else {
                        inx = fam.toLowerCase().lastIndexOf(STYLE_BLACK);
                        if (inx > 0) {
                            fam = fam.substring(0, inx);
                        }
                    }
                }
            }
        }
        return fam;
    }

    public static String removeBaseFontSubset(String name) {
        if (name != null && name.length() > 7) {
            int i = name.indexOf(43) + 1;
            return name.substring(i, name.length());
        }
        return name;
    }

    public static String normalizeString(String name) {
        name = FontUtil.guessFamily(name);
        StringBuilder normalized = new StringBuilder(name.toLowerCase());
        for (int k = normalized.length() - 1; k >= 0; --k) {
            if (normalized.charAt(k) != ' ') continue;
            normalized.deleteCharAt(k);
            --k;
        }
        return normalized.toString();
    }
}

