/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.exceptions.FileNotInPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.exceptions.UnsupportedAlgorithmException;
import gov.loc.repository.bagit.hash.BagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.hash.StandardBagitAlgorithmNameToSupportedAlgorithmMapping;
import gov.loc.repository.bagit.reader.ManifestReader;
import gov.loc.repository.bagit.util.PathUtils;
import gov.loc.repository.bagit.verify.CheckIfFileExistsTask;
import gov.loc.repository.bagit.verify.PayloadFileExistsInAllManifestsVistor;
import gov.loc.repository.bagit.verify.PayloadFileExistsInAtLeastOneManifestVistor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class PayloadVerifier
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PayloadVerifier.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private final transient BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping;
    private final transient ExecutorService executor;

    public PayloadVerifier() {
        this(new StandardBagitAlgorithmNameToSupportedAlgorithmMapping(), Executors.newCachedThreadPool());
    }

    public PayloadVerifier(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping) {
        this(nameMapping, Executors.newCachedThreadPool());
    }

    public PayloadVerifier(ExecutorService executor) {
        this(new StandardBagitAlgorithmNameToSupportedAlgorithmMapping(), executor);
    }

    public PayloadVerifier(BagitAlgorithmNameToSupportedAlgorithmMapping nameMapping, ExecutorService executor) {
        this.nameMapping = nameMapping;
        this.executor = executor;
    }

    @Override
    public void close() throws SecurityException {
        this.executor.shutdown();
    }

    public void verifyPayload(Bag bag, boolean ignoreHiddenFiles) throws IOException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException, FileNotInPayloadDirectoryException, InterruptedException {
        Set<Path> allFilesListedInManifests = this.getAllFilesListedInManifests(bag);
        this.checkAllFilesListedInManifestExist(allFilesListedInManifests);
        if (bag.getVersion().isOlder(new Version(1, 0))) {
            PayloadVerifier.checkAllFilesInPayloadDirAreListedInAtLeastOneAManifest(allFilesListedInManifests, PathUtils.getDataDir(bag), ignoreHiddenFiles);
        } else {
            PayloadVerifier.CheckAllFilesInPayloadDirAreListedInAllManifests(bag.getPayLoadManifests(), PathUtils.getDataDir(bag), ignoreHiddenFiles);
        }
    }

    private Set<Path> getAllFilesListedInManifests(Bag bag) throws IOException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException {
        logger.debug(messages.getString("all_files_in_manifests"));
        HashSet<Path> filesListedInManifests = new HashSet<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(PathUtils.getBagitDir(bag.getVersion(), bag.getRootDir()));){
            for (Path path : directoryStream) {
                String filename = PathUtils.getFilename(path);
                if (!filename.startsWith("tagmanifest-") && !filename.startsWith("manifest-")) continue;
                logger.debug(messages.getString("get_listing_in_manifest"), (Object)path);
                Manifest manifest = ManifestReader.readManifest(this.nameMapping, path, bag.getRootDir(), bag.getFileEncoding());
                filesListedInManifests.addAll(manifest.getFileToChecksumMap().keySet());
            }
        }
        return filesListedInManifests;
    }

    private void checkAllFilesListedInManifestExist(Set<Path> files) throws FileNotInPayloadDirectoryException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(files.size());
        ConcurrentSkipListSet<Path> missingFiles = new ConcurrentSkipListSet<Path>();
        logger.info(messages.getString("check_all_files_in_manifests_exist"));
        for (Path file : files) {
            this.executor.execute(new CheckIfFileExistsTask(file, missingFiles, latch));
        }
        latch.await();
        if (!missingFiles.isEmpty()) {
            String formattedMessage = messages.getString("missing_payload_files_error");
            throw new FileNotInPayloadDirectoryException(MessageFormatter.format((String)formattedMessage, missingFiles).getMessage());
        }
    }

    private static void checkAllFilesInPayloadDirAreListedInAtLeastOneAManifest(Set<Path> filesListedInManifests, Path payloadDir, boolean ignoreHiddenFiles) throws IOException {
        logger.debug(messages.getString("checking_file_in_at_least_one_manifest"), (Object)payloadDir);
        if (Files.exists(payloadDir, new LinkOption[0])) {
            Files.walkFileTree(payloadDir, new PayloadFileExistsInAtLeastOneManifestVistor(filesListedInManifests, ignoreHiddenFiles));
        }
    }

    private static void CheckAllFilesInPayloadDirAreListedInAllManifests(Set<Manifest> payLoadManifests, Path payloadDir, boolean ignoreHiddenFiles) throws IOException {
        logger.debug(messages.getString("checking_file_in_all_manifests"), (Object)payloadDir);
        if (Files.exists(payloadDir, new LinkOption[0])) {
            Files.walkFileTree(payloadDir, new PayloadFileExistsInAllManifestsVistor(payLoadManifests, ignoreHiddenFiles));
        }
    }
}

