/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.NamedThreadFactory;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.SuspendableThreadPoolExecutor;
import org.jodconverter.core.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficeManagerPoolEntry
implements OfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPoolEntry.class);
    private final long taskExecutionTimeout;
    private final SuspendableThreadPoolExecutor taskExecutor;
    private Future<?> currentFuture;

    protected AbstractOfficeManagerPoolEntry(long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
        this.taskExecutor = new SuspendableThreadPoolExecutor(new NamedThreadFactory("jodconverter-poolentry"));
    }

    @Override
    public final void execute(@NonNull OfficeTask task) throws OfficeException {
        this.currentFuture = this.taskExecutor.submit(() -> {
            this.doExecute(task);
            return null;
        });
        try {
            LOGGER.debug("Waiting {} ms for task to complete: {}", (Object)this.taskExecutionTimeout, (Object)task);
            this.currentFuture.get(this.taskExecutionTimeout, TimeUnit.MILLISECONDS);
            LOGGER.debug("Task executed successfully: {}", (Object)task);
        }
        catch (CancellationException ex) {
            throw new OfficeException(String.format("Task was cancelled: %s", task), ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof OfficeException) {
                throw (OfficeException)ex.getCause();
            }
            throw new OfficeException(String.format("Task did not complete: %s", task), ex.getCause());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new OfficeException(String.format("Task was interrupted while executing: %s", task), ex);
        }
        catch (TimeoutException ex) {
            this.handleExecuteTimeoutException(ex);
            throw new OfficeException(String.format("Task did not complete within timeout: %s", task), ex);
        }
        finally {
            this.currentFuture = null;
        }
    }

    protected abstract void doExecute(@NonNull OfficeTask var1) throws OfficeException;

    protected void handleExecuteTimeoutException(@NonNull TimeoutException timeoutEx) {
        LOGGER.debug("Handling task execution timeout.", (Throwable)timeoutEx);
    }

    @Override
    public boolean isRunning() {
        return !this.taskExecutor.isShutdown();
    }

    @Override
    public final void start() throws OfficeException {
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("This office manager (pool entry) has been shutdown.");
        }
        this.doStart();
    }

    @Override
    public final void stop() throws OfficeException {
        this.taskExecutor.setAvailable(false);
        this.taskExecutor.shutdownNow();
        this.doStop();
    }

    protected void cancelTask() {
        if (this.currentFuture != null) {
            LOGGER.debug("Cancelling current task...");
            this.currentFuture.cancel(true);
        }
    }

    protected void setAvailable(boolean available) {
        this.taskExecutor.setAvailable(available);
    }

    protected abstract void doStart() throws OfficeException;

    protected abstract void doStop() throws OfficeException;
}

