/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.normalizers;

import com.exlibris.core.infra.common.normalizers.Normalizer;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.common.util.UnicodeToWordMapper;

public class UnicodeNormalizer
implements Normalizer {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public String normalize(String content) {
        if (content != null) {
            char[] ch = content.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                String hexIn = UnicodeNormalizer.charToHex(ch[i]).toUpperCase();
                String hexOut = (String)UnicodeToWordMapper.getInstance().getUnicode2Word().get(hexIn);
                if (hexOut == null || hexIn.equals(hexOut)) continue;
                ch[i] = (char)Integer.parseInt(hexOut, 16);
            }
            return StringUtils.removeAllCharOccurrences('\u0000', new String(ch));
        }
        return content;
    }

    private static String byteToHex(byte b) {
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    private static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return UnicodeNormalizer.byteToHex(hi) + UnicodeNormalizer.byteToHex(lo);
    }
}

