/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.xml;

import com.exlibris.core.infra.common.util.KmpStringFinder;
import java.util.ArrayList;

public class XMLNormalizer {
    private static XMLNormalizer instance = new XMLNormalizer();
    public static final char[] cAmp = new char[]{'&', 'a', 'm', 'p', ';'};
    public static final char[] cGreaterThan = new char[]{'&', 'g', 't', ';'};
    public static final char[] cLessThan = new char[]{'&', 'l', 't', ';'};
    public static final char[] cQuote = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    public static final char[] cNbsp = new char[]{'&', 'n', 'b', 's', 'p', ';'};

    public static XMLNormalizer getInstance() {
        return instance;
    }

    public static String normalize(String s) {
        StringBuffer m_normalizedStrBuffer = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    m_normalizedStrBuffer.append(cLessThan);
                    continue block6;
                }
                case '>': {
                    m_normalizedStrBuffer.append(cGreaterThan);
                    continue block6;
                }
                case '&': {
                    String temp = s.substring(i + 1);
                    if (temp != null) {
                        if (temp.startsWith("amp;") || temp.startsWith("lt;") || temp.startsWith("gt;") || temp.startsWith("quot;")) {
                            m_normalizedStrBuffer.append(ch);
                            continue block6;
                        }
                        m_normalizedStrBuffer.append(cAmp);
                        continue block6;
                    }
                    m_normalizedStrBuffer.append(cAmp);
                    continue block6;
                }
                case '\"': {
                    m_normalizedStrBuffer.append(cQuote);
                    continue block6;
                }
                default: {
                    m_normalizedStrBuffer.append(ch);
                }
            }
        }
        return m_normalizedStrBuffer.toString();
    }

    public String normalize(char[] i_buf, int i_offset, int i_len) {
        StringBuffer m_normalizedStrBuffer = new StringBuffer();
        int len = i_offset + i_len;
        block6: for (int i = i_offset; i < len; ++i) {
            switch (i_buf[i]) {
                case '<': {
                    m_normalizedStrBuffer.append(cLessThan);
                    continue block6;
                }
                case '>': {
                    m_normalizedStrBuffer.append(cGreaterThan);
                    continue block6;
                }
                case '&': {
                    String temp = i_buf.toString().substring(i + 1);
                    if (temp != null) {
                        if (temp.startsWith("amp;") || temp.startsWith("lt;") || temp.startsWith("gt;") || temp.startsWith("quot;")) {
                            m_normalizedStrBuffer.append(i_buf[i]);
                            continue block6;
                        }
                        m_normalizedStrBuffer.append(cAmp);
                        continue block6;
                    }
                    m_normalizedStrBuffer.append(cAmp);
                    continue block6;
                }
                case '\"': {
                    m_normalizedStrBuffer.append(cQuote);
                    continue block6;
                }
                default: {
                    m_normalizedStrBuffer.append(i_buf[i]);
                }
            }
        }
        return m_normalizedStrBuffer.toString();
    }

    public static synchronized String deNormalize(String s) {
        int pos;
        int i;
        int pos2;
        int i2;
        StringBuffer buffer = new StringBuffer(s);
        KmpStringFinder kmp = new KmpStringFinder();
        ArrayList res = kmp.KMP(new String(cAmp), s);
        int size = res.size();
        int differnceInSizes = 4;
        for (i2 = 0; i2 < size; ++i2) {
            pos2 = (Integer)res.get(i2);
            buffer.replace(pos2 - i2 * differnceInSizes, pos2 - i2 * differnceInSizes + 5, "&");
        }
        res = kmp.KMP(new String(cLessThan), buffer.toString());
        size = res.size();
        differnceInSizes = 3;
        for (i2 = 0; i2 < size; ++i2) {
            pos2 = (Integer)res.get(i2);
            buffer.replace(pos2 - i2 * differnceInSizes, pos2 - i2 * differnceInSizes + 4, "<");
        }
        res = kmp.KMP(new String(cGreaterThan), buffer.toString());
        size = res.size();
        for (i2 = 0; i2 < size; ++i2) {
            pos2 = (Integer)res.get(i2);
            buffer.replace(pos2 - i2 * differnceInSizes, pos2 - i2 * differnceInSizes + 4, ">");
        }
        res = kmp.KMP(new String(cQuote), buffer.toString());
        size = res.size();
        boolean h = false;
        differnceInSizes = 5;
        for (i = 0; i < size; ++i) {
            pos = (Integer)res.get(i);
            buffer.replace(pos - i * differnceInSizes, pos - i * differnceInSizes + 6, "\"");
        }
        res = kmp.KMP(new String(cNbsp), buffer.toString());
        size = res.size();
        differnceInSizes = 5;
        for (i = 0; i < size; ++i) {
            pos = (Integer)res.get(i);
            buffer.replace(pos - i * differnceInSizes, pos - i * differnceInSizes + 6, " ");
        }
        return buffer.toString();
    }
}

