/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.consortium;

import com.exlibris.core.infra.model.consortium.HFrConsortium;
import com.exlibris.core.infra.model.consortium.HFrDepartment;
import com.exlibris.core.infra.model.consortium.HFrHierarchyEntity;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findConsortiumByInstitutionCode", query="select inst.consortium from HFrInstitution inst where UPPER(inst.code) = :code"), @NamedQuery(name="findConsortiumByInstitutionPath", query="select inst.consortium from HFrInstitution inst where UPPER(inst.path) = :path"), @NamedQuery(name="findInstitutionByCode", query="from HFrInstitution inst where UPPER(inst.code) = :code"), @NamedQuery(name="findInstitutionByPath", query="from HFrInstitution inst where UPPER(inst.path) = :path"), @NamedQuery(name="findNumberOfInstitutionsByConsortium", query="select count(inst) from HFrInstitution inst where inst.consortium = :consortium")})
@Table(name="HFrInstitution")
public class HFrInstitution
extends HFrHierarchyEntity {
    private static final long serialVersionUID = 1L;
    private HFrConsortium consortium;
    private List<HFrDepartment> departments;
    private Long uiCustomizationId;

    public HFrInstitution(String code, String path) {
        super(code, path);
    }

    public HFrInstitution() {
    }

    @ManyToOne(targetEntity=HFrConsortium.class)
    @JoinColumn(name="consortium_id", nullable=false)
    @Index(name="CONSORTIUM_ID_IDX")
    public HFrConsortium getConsortium() {
        return this.consortium;
    }

    public void setConsortium(HFrConsortium frConsortium) {
        this.consortium = frConsortium;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="institution_id", updatable=false)
    public List<HFrDepartment> getDepartments() {
        return this.departments;
    }

    public void setDepartments(List<HFrDepartment> hFrDepartment) {
        this.departments = hFrDepartment;
    }

    public void addDepartment(HFrDepartment newDepartment) {
        if (this.getDepartments() == null) {
            this.setDepartments(new ArrayList<HFrDepartment>());
        }
        newDepartment.setInstitution(this);
        this.getDepartments().add(newDepartment);
    }

    @Column(name="UI_CUSTOMIZATION_ID")
    public Long getUiCustomizationId() {
        return this.uiCustomizationId;
    }

    public void setUiCustomizationId(Long uiCustomizationId) {
        this.uiCustomizationId = uiCustomizationId;
    }
}

