/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.security.SimpleGroup;
import com.exlibris.core.infra.svc.api.security.SimplePrincipal;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class AbstractServerLoginModule
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    protected boolean useFirstPass;
    protected boolean loginOk;
    protected String principalClassName;
    protected Principal unauthenticatedIdentity;
    protected ExLogger log = ExLogger.getExLogger(AbstractServerLoginModule.class);

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.log = ExLogger.getExLogger(this.getClass());
        if (this.log.isTraceEnabled()) {
            this.log.trace("initialize, instance=@" + System.identityHashCode(this));
        }
        if ((passwordStacking = (String)options.get("password-stacking")) != null && passwordStacking.equalsIgnoreCase("useFirstPass")) {
            this.useFirstPass = true;
        }
        this.principalClassName = (String)options.get("principalClass");
        String name = (String)options.get("unauthenticatedIdentity");
        if (name == null) {
            return;
        }
        try {
            this.unauthenticatedIdentity = this.createIdentity(name);
            this.log.trace("Saw unauthenticatedIdentity=" + name);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to create custom unauthenticatedIdentity", e, new String[0]);
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.log.trace("login");
        this.loginOk = false;
        if (this.useFirstPass) {
            try {
                Object identity = this.sharedState.get("javax.security.auth.login.name");
                Object credential = this.sharedState.get("javax.security.auth.login.password");
                if (identity != null && credential != null) {
                    this.loginOk = true;
                    return true;
                }
            }
            catch (Exception e) {
                this.log.error("login failed", e, new String[0]);
            }
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        this.log.trace("commit, loginOk=" + this.loginOk);
        if (!this.loginOk) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        Principal identity = this.getIdentity();
        principals.add(identity);
        Group[] roleSets = this.getRoleSets();
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        return true;
    }

    protected Group createGroup(String name, Set principals) {
        SimpleGroup roles = null;
        for (Object next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    @Override
    public boolean abort() throws LoginException {
        this.log.trace("abort");
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.log.trace("logout");
        Principal identity = this.getIdentity();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(identity);
        return true;
    }

    protected abstract Principal getIdentity();

    protected abstract Group[] getRoleSets() throws LoginException;

    protected boolean getUseFirstPass() {
        return this.useFirstPass;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Principal createIdentity(String username) throws Exception {
        Principal p = null;
        if (this.principalClassName == null) {
            p = new SimplePrincipal(username);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(this.principalClassName);
            Class[] ctorSig = new Class[]{String.class};
            Constructor<?> ctor = clazz.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{username};
            p = (Principal)ctor.newInstance(ctorArgs);
        }
        return p;
    }
}

