/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.policy;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.storage.Storage;
import com.exlibris.core.infra.model.storage.StorageCapacity;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.storage.policy.AbstractStoragePolicyFS;
import java.util.List;

public class StorageOrderedPolicy
extends AbstractStoragePolicyFS {
    ExLogger logger = ExLogger.getExLogger(StorageOrderedPolicy.class);

    @Override
    public synchronized Storage selectStorage(List<Storage> storages, StoredEntityMetaData storedEntityMetaData) {
        for (Storage storage : storages) {
            Long fileSizeInBytes = storedEntityMetaData.getSizeInBytes();
            StorageCapacity capacity = this.getStorageService().getStorageCapacity(storage.getId());
            if (capacity == null) {
                capacity = this.createNewCapacity(storage);
            }
            if (!this.updateStorageCapacity(storage, capacity, fileSizeInBytes).booleanValue()) continue;
            return storage;
        }
        throw new RuntimeException("Insufficient Storages Space In Group: " + storages.get(0).getGroup().getName());
    }
}

