/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.policy;

import com.exlibris.core.infra.model.storage.Storage;
import com.exlibris.core.infra.model.storage.StorageCapacity;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.storage.policy.AbstractStoragePolicyFS;
import java.util.ArrayList;
import java.util.List;

public class StorageRandomPolicy
extends AbstractStoragePolicyFS {
    @Override
    public Storage selectStorage(List<Storage> storages, StoredEntityMetaData storedEntityMetaData) {
        ArrayList<Storage> storagesTmp = new ArrayList<Storage>(storages);
        while (storagesTmp.size() > 0) {
            int random = (int)(Math.random() * 100000.0) % storagesTmp.size();
            Storage storage = (Storage)storagesTmp.get(random);
            Long fileSizeInBytes = this.getRealFileSize(storage, storedEntityMetaData.getSizeInBytes());
            StorageCapacity capacity = this.getStorageService().getStorageCapacity(storage.getId());
            if (capacity == null) {
                capacity = this.createNewCapacity(storage);
            }
            if (this.updateStorageCapacity(storage, capacity, fileSizeInBytes).booleanValue()) {
                return storage;
            }
            storagesTmp.remove(random);
        }
        throw new RuntimeException("Insufficient Storages Space In Group: " + storages.get(0).getGroup().getName());
    }
}

