/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.common.dnx.DNXProfile;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxErrorReport;
import com.exlibris.digitool.common.dnx.DnxRecordKey;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionErrorReport;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import com.exlibris.digitool.common.dnx.DnxValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DnxValidatorDefaultImpl
implements DnxValidator {
    protected DNXProfile profile = null;
    protected Enum.ObjectType type = null;
    protected List<DnxErrorReport> errors = null;

    public DnxValidatorDefaultImpl() {
    }

    public DnxValidatorDefaultImpl(DNXProfile profile) {
        this.profile = profile;
    }

    @Override
    public void setType(Enum.ObjectType type) {
        this.type = type;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
    }

    @Override
    public List<DnxErrorReport> validate(DnxDocument doc) {
        this.init();
        if (this.profile != null) {
            this.validateDocument(doc);
        }
        return this.errors;
    }

    @Override
    public List<DnxErrorReport> validate(String sectionid, DnxSectionRecord record) {
        this.init();
        if (this.profile != null) {
            this.validateRecord(sectionid, record);
        }
        return this.errors;
    }

    protected void validateDocument(DnxDocument doc) {
        List<String> psections;
        if (doc == null) {
            return;
        }
        List<DnxSection> docsections = doc.getSectionsList();
        if (docsections != null) {
            for (int x = 0; x < docsections.size(); ++x) {
                this.validateSection(docsections.get(x));
            }
        }
        if ((psections = this.getSections()) != null) {
            for (int x = 0; x < psections.size(); ++x) {
                String sectionid = psections.get(x);
                if (!this.profile.isMandatoryForStaging(sectionid) || doc.getSectionById(sectionid) != null) continue;
                this.addErrorReport(this.createErrorMessage("dnx.validate.section.mandatory", sectionid, null, null));
            }
        }
    }

    protected void validateSection(DnxSection section) {
        if (section == null) {
            return;
        }
        String sectionid = section.getId();
        if (!this.profile.hasSection(sectionid)) {
            this.addErrorReport(this.createErrorMessage("dnx.validate.section.notinprofile", sectionid, null, null));
        } else {
            if (this.type != null && !this.isRelevant(sectionid)) {
                this.addErrorReport(this.createErrorMessage("dnx.validate.section.relevancy", sectionid, this.type.toString(), null));
            }
            this.validateRecords(section);
        }
    }

    protected void validateRecords(DnxSection section) {
        if (section == null) {
            return;
        }
        String sectionid = section.getId();
        int numberofrecords = 0;
        if (section.getRecordList() != null) {
            numberofrecords = section.getRecordList().size();
        }
        if (numberofrecords == 0) {
            return;
        }
        if (numberofrecords > 1 && !this.profile.isRepeatable(sectionid)) {
            this.addErrorReport(this.createErrorMessage("dnx.validate.section.replication", sectionid, null, null));
            return;
        }
        for (int x = 0; x < numberofrecords; ++x) {
            this.validateRecord(sectionid, section.getRecordList().get(x));
        }
    }

    protected void validateRecord(String sectionid, DnxSectionRecord record) {
        List<String> pkeys;
        if (sectionid == null || record == null) {
            return;
        }
        List<DnxRecordKey> dockeys = record.getKeylist();
        if (dockeys != null) {
            for (int x = 0; x < dockeys.size(); ++x) {
                this.validateKey(sectionid, dockeys.get(x));
            }
        }
        if ((pkeys = this.profile.getSectionKeyList(sectionid)) != null) {
            for (int x = 0; x < pkeys.size(); ++x) {
                String keyid = pkeys.get(x);
                if (!this.profile.isMandatoryForStageing(sectionid, keyid) || record.getKeyById(keyid) != null) continue;
                this.addErrorReport(this.createErrorMessage("dnx.validate.key.mandatory", sectionid, keyid, null));
            }
        }
    }

    protected void validateKey(String sectionid, DnxRecordKey key) {
        if (sectionid == null || key == null) {
            return;
        }
        String keyid = key.getId();
        if (keyid == null) {
            return;
        }
        if (!this.profile.hasSectionKey(sectionid, keyid)) {
            this.addErrorReport(this.createErrorMessage("dnx.validate.key.notinprofile", sectionid, keyid, null));
        } else {
            if (!this.isValid(key.getValue(), this.profile.getSectionKeyType(sectionid, keyid))) {
                this.addErrorReport(this.createErrorMessage("dnx.validate.key.datatype", sectionid, keyid, this.profile.getSectionKeyType(sectionid, keyid).toString()));
                return;
            }
            String routine = this.profile.getValidationRoutine(sectionid, keyid);
            if (routine == null || routine.length() > 0) {
                // empty if block
            }
        }
    }

    protected boolean isRelevant(String sectionid) {
        if (this.type != null) {
            if (Enum.ObjectType.INTELLECTUAL_ENTITY.equals((Object)this.type)) {
                return this.profile.isRelevantForIE(sectionid);
            }
            if (Enum.ObjectType.REPRESENTATION.equals((Object)this.type)) {
                return this.profile.isRelevantForREP(sectionid);
            }
            if (Enum.ObjectType.FILE.equals((Object)this.type)) {
                return this.profile.isRelevantForFILE(sectionid);
            }
        }
        return false;
    }

    protected boolean isValid(String data, DNXProfile.SectionKeyType type) {
        if (data == null || data.length() == 0) {
            return true;
        }
        if (DNXProfile.SectionKeyType.INT.equals((Object)type)) {
            try {
                Integer.parseInt(data);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (DNXProfile.SectionKeyType.BOOLEAN.equals((Object)type)) {
            try {
                Boolean.parseBoolean(data);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    protected void init() {
        if (this.errors == null) {
            this.errors = new ArrayList<DnxErrorReport>();
        } else {
            this.errors.clear();
        }
        if (this.profile == null) {
            this.addErrorReport(this.createErrorMessage("dnx.validate.failed", null, null, null));
        }
    }

    protected void addErrorReport(String code) {
        DnxSectionErrorReport report = new DnxSectionErrorReport();
        report.setErrorCode(code);
        report.setErrorSeverity(DnxErrorReport.ErrorSeverity.ERROR);
        this.errors.add(report);
    }

    protected String createErrorMessage(String errorCode, String parm1, String parm2, String parm3) {
        String errorStr = null;
        Object[] params = new Object[5];
        try {
            if (parm1 != null && parm1.length() > 0) {
                params[0] = parm1;
            }
            if (parm2 != null && parm2.length() > 0) {
                params[1] = parm2;
            }
            if (parm3 != null && parm3.length() > 0) {
                params[2] = parm3;
            }
            errorStr = this.getErrorMsg(errorCode);
        }
        catch (Exception E) {
            errorStr = "The parameters to the logger message formatter were not as expected";
        }
        return MessageFormat.format(errorStr, params);
    }

    @Override
    public String getErrorMsg(String errorCode) {
        String errorMsg = null;
        if ("dnx.validate.section.notinprofile".equals(errorCode)) {
            errorMsg = "{0} is not in profile";
        } else if ("dnx.validate.section.relevancy".equals(errorCode)) {
            errorMsg = "{0} is not relevant for object type {1}";
        } else if ("dnx.validate.section.mandatory".equals(errorCode)) {
            errorMsg = "{0} is mandatory";
        } else if ("dnx.validate.section.replication".equals(errorCode)) {
            errorMsg = "{0} can not have multiple records";
        } else if ("dnx.validate.key.mandatory".equals(errorCode)) {
            errorMsg = "{0}.{1} is mandatory";
        } else if ("dnx.validate.key.datatype".equals(errorCode)) {
            errorMsg = "{0}.{1} is {2} field";
        } else if ("dnx.validate.key.notinprofile".equals(errorCode)) {
            errorMsg = "{0}.{1} is not in profile";
        } else if ("dnx.validate.failed".equals(errorCode)) {
            errorMsg = "Editor cannot validate the document. Check profile and message properties file to make sure they are existed";
        }
        return errorMsg;
    }

    private List<String> getSections() {
        if (this.type == null) {
            return this.profile.getSectionList();
        }
        if (Enum.ObjectType.INTELLECTUAL_ENTITY.equals((Object)this.type)) {
            return this.profile.getSectionListForIE();
        }
        if (Enum.ObjectType.FILE.equals((Object)this.type)) {
            return this.profile.getSectionListForFILE();
        }
        if (Enum.ObjectType.REPRESENTATION.equals((Object)this.type)) {
            return this.profile.getSectionListForREP();
        }
        return null;
    }
}

