/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class HTMLTagsFilterReader
extends InputStreamReader {
    boolean intag = false;
    boolean inspace = false;

    public HTMLTagsFilterReader(InputStream in) throws UnsupportedEncodingException {
        super(in, "UTF-8");
    }

    @Override
    public int read(char[] buf, int from, int len) throws IOException {
        int numchars = 0;
        while (numchars == 0) {
            numchars = super.read(buf, from, len);
            if (numchars == -1) {
                return -1;
            }
            int last = from;
            for (int i = from; i < from + numchars; ++i) {
                if (!this.intag) {
                    if (buf[i] == '<') {
                        this.intag = true;
                        continue;
                    }
                    if (buf[i] == ' ') {
                        if (this.inspace) continue;
                        this.inspace = true;
                    } else {
                        this.inspace = false;
                    }
                    buf[last++] = buf[i];
                    continue;
                }
                if (buf[i] != '>') continue;
                this.intag = false;
            }
            numchars = last - from;
        }
        return numchars;
    }

    @Override
    public int read() throws IOException {
        char[] buf = new char[1];
        int result = this.read(buf, 0, 1);
        if (result == -1) {
            return -1;
        }
        return buf[0];
    }
}

