/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.delivery;

import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.dps.sdk.delivery.SmartFilePath;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlbeans.XmlException;

public class ViewerData
implements Serializable {
    private static final long serialVersionUID = 3L;
    private String dvs;
    private String pid;
    private String parentPid;
    private String profile;
    private String userIP;
    private String userName;
    private String language;
    private String institutionPath;
    private transient IEParser ie = null;
    private String ieXml = null;
    private long options;
    private boolean confirmedCopyrights;
    private boolean isConcurrentAR;
    private DublinCore cms;
    private final Map<String, DnxDocument> fileDnxs = new HashMap<String, DnxDocument>();
    private final Map<String, SmartFilePath> filePaths = new HashMap<String, SmartFilePath>();
    private final Map<String, List<HDeMetadata>> fileMetadatas;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, String> collections;
    private Integer version;
    private List<String> repPidList;
    private List<String> filePidList;

    public ViewerData() {
        this.fileMetadatas = new HashMap<String, List<HDeMetadata>>();
    }

    public String getDvs() {
        return this.dvs;
    }

    public void setDvs(String dvs) {
        this.dvs = dvs;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setUserIP(String userIP) {
        this.userIP = userIP;
    }

    public String getUserIP() {
        return this.userIP;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public IEParser getIe() {
        if (this.ie == null && this.ieXml != null) {
            try {
                this.ie = IEParserFactory.parse(this.ieXml);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
        return this.ie;
    }

    public void setIe(IEParser ie) {
        this.ie = ie;
        this.ieXml = ie.toXML();
    }

    public boolean isConfirmedCopyrights() {
        return this.confirmedCopyrights;
    }

    public void setConfirmedCopyrights(boolean confirmedCopyrights) {
        this.confirmedCopyrights = confirmedCopyrights;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParametersString() {
        String convertMapParamValueToString = "";
        Iterator<String> iter = this.parameters.keySet().iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            String value = String.valueOf(this.parameters.get(param));
            convertMapParamValueToString = convertMapParamValueToString + param + "=" + value + (iter.hasNext() ? "," : "");
        }
        return StringEscapeUtils.escapeSql((String)convertMapParamValueToString);
    }

    public Map<String, SmartFilePath> getFilePaths() {
        return this.filePaths;
    }

    public SmartFilePath getFilePath(String pid) {
        return this.filePaths.get(pid);
    }

    public Map<String, DnxDocument> getFileDnxs() {
        return this.fileDnxs;
    }

    public DnxDocument getFileDnx(String pid) {
        return this.fileDnxs.get(pid);
    }

    public Map<String, List<HDeMetadata>> getFileMetadatas() {
        return this.fileMetadatas;
    }

    public List<HDeMetadata> getFileMetadatas(String pid) {
        return this.fileMetadatas.get(pid);
    }

    public void addFilePath(String pid, SmartFilePath filePath) {
        this.filePaths.put(pid, filePath);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    public void addFileDnx(String pid, DnxDocument dnxDoc) {
        if (dnxDoc != null) {
            dnxDoc.setDocumentXml(dnxDoc.getDocument().asXML());
        }
        this.fileDnxs.put(pid, dnxDoc);
    }

    public void addFileMetadatas(String pid, List<HDeMetadata> metadatas) {
        this.fileMetadatas.put(pid, metadatas);
    }

    public String getIeXml() {
        return this.ieXml;
    }

    public void setIeXml(String ieXml) {
        this.ieXml = ieXml;
    }

    public DublinCore getCms() {
        return this.cms;
    }

    public void setCms(DublinCore cms) {
        this.cms = cms;
    }

    public String getParentPid() {
        return this.parentPid;
    }

    public void setParentPid(String parentPid) {
        this.parentPid = parentPid;
    }

    public boolean isConcurrentAR() {
        return this.isConcurrentAR;
    }

    public void setConcurrentAR(boolean isConcurrentAR) {
        this.isConcurrentAR = isConcurrentAR;
    }

    public Map<String, String> getCollections() {
        return this.collections;
    }

    public void setCollections(Map<String, String> collections) {
        this.collections = collections;
    }

    public String getInstitutionPath() {
        return this.institutionPath;
    }

    public void setInstitutionPath(String institutionPath) {
        this.institutionPath = institutionPath;
    }

    public String toString() {
        return "PID: " + this.pid + ", dvs: " + this.dvs + ", profile: " + this.profile;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public long getOptions() {
        return this.options;
    }

    public void setOptions(long options) {
        this.options = options;
    }

    public List<String> getRepPidList() {
        return this.repPidList;
    }

    public void setRepPidList(List<String> repPidList) {
        this.repPidList = repPidList;
    }

    public List<String> getFilePidList() {
        return this.filePidList;
    }

    public void setFilePidList(List<String> filePidList) {
        this.filePidList = filePidList;
    }
}

