/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.deposit;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;

public class IEParserTest {
    public static void main(String[] args) {
        try {
            IEParser ie = IEParserFactory.create();
            DublinCore dc = ie.getDublinCoreParser();
            dc.addElement("dc:title", "My Title");
            ie.setIEDublinCore(dc);
            DnxDocument dnx = ie.getDnxParser();
            dnx.createSection("cms").createRecord().updateKey("systemid", "1001");
            dnx.updateSectionKey(DNXConstants.METADATA.CREATEDBY, "zvi");
            ie.setIeDnx(dnx);
            MetsType.FileSec.FileGrp fGrp = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
            ie.addNewFile(fGrp, "image/jpeg", "/streams/OMSObject3155/3155_pm_01.tif", "label1");
            ie.addNewFile(fGrp, "image/jpeg", "/streams/OMSObject3155/test.jpeg", "label2");
            MetsType.FileSec.FileGrp fGrp2 = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
            ie.addNewFile(fGrp2, "image/jpeg", "/streams/OMSObject3155/test1.tif", "test1");
            ie.addNewFile(fGrp2, "image/jpeg", "/streams/OMSObject3155/test2.jpeg", "testl2");
            ie.generateStructMap(null, "testLabel");
            System.out.println(ie.toXML());
            ie.getFileGrp(fGrp2.getID()).removeFile(0);
            ie.generateStructMap(null, "testLabel");
            System.out.println(ie.toXML());
            ie.fixIdNaming();
            MetsDocument mets1 = MetsDocument.Factory.newInstance();
            mets1.addNewMets();
            MetsDocument.Mets mets = mets1.getMets();
            StructMapType sm = mets.addNewStructMap();
            sm.setID("zzz");
            sm.setTYPE("TEST");
            ie.addAdditionalStructMap(ie.getFileGrp("rep1"), sm);
            System.out.println("strusctMap:" + ie.getStructMapById("rep1-2").toString());
            ie.getStructMapsByFileGrpId("rep1");
            System.out.println("ie :" + ie.toXML());
            System.out.println(ie.getFileGrpDnx(fGrp.getID()).toString());
            System.out.println(ie.toXML());
            System.out.println(ie.getIeDublinCore().toXml());
            System.out.println("--------------------------------------");
            ie.setStructMap(fGrp2, "<structMap ID=\"" + fGrp2.getID() + "\" TYPE=\"PHYSICAL\"><div LABEL=\"MODIFIED_MASTER;VIEW\"><div LABEL=\"aaa\"><fptr FILEID=\"FL2003\"/></div></div></structMap>");
            System.out.println(ie.getStructMap(fGrp2.getID()).toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

