/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.xml;

import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.FileFormatCollection;
import uk.gov.nationalarchives.droid.core.signature.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignature;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureCollection;
import uk.gov.nationalarchives.droid.core.signature.droid6.LeftFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.RightFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.Shift;
import uk.gov.nationalarchives.droid.core.signature.droid6.SubSequence;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SAXModelBuilder
extends DefaultHandler {
    private static final String SUB_SEQUENCE = "SubSequence";
    private static final String BYTE_SEQUENCE = "ByteSequence";
    private static final String INTERNAL_SIGNATURE = "InternalSignature";
    private static final String FFSIGNATURE_FILE = "FFSignatureFile";
    private static final String INTERNAL_SIGNATURE_COLLECTION = "InternalSignatureCollection";
    private static final String FILE_FORMAT = "FileFormat";
    private static final String FILE_FORMAT_COLLECTION = "FileFormatCollection";
    private static final String EXTENSION = "Extension";
    private static final String INTERNAL_SIGNATURE_ID = "InternalSignatureID";
    private static final String HAS_PRIORITY_OVER_FILE_FORMAT_ID = "HasPriorityOverFileFormatID";
    private static final String LEFT_FRAGMENT = "LeftFragment";
    private static final String RIGHT_FRAGMENT = "RightFragment";
    private static final String SEQUENCE = "Sequence";
    private static final String SHIFT = "Shift";
    private static final String DEFAULT_SHIFT = "DefaultShift";
    private static final String FILE_FORMAT_HIT = "FileFormatHit";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Stack<Object> stack = new Stack();
    private SimpleElement element;
    private String namespace = "";
    private boolean useNamespace;
    private boolean allowGlobalNamespace = true;

    public void setupNamespace(String nspace, boolean globalNamespace) {
        if (nspace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.namespace = nspace;
        this.useNamespace = true;
        this.allowGlobalNamespace = globalNamespace;
    }

    private String handleNameNS(String nspace, String localname, String qname) {
        String result = null;
        if (this.useNamespace && this.namespace.equals(nspace)) {
            result = localname;
        } else if (this.allowGlobalNamespace && "".equals(nspace)) {
            result = qname;
        }
        return result;
    }

    @Override
    public void startElement(String nspace, String localname, String qname, Attributes atts) {
        String elementName = this.handleNameNS(nspace, localname, qname);
        if (elementName == null) {
            return;
        }
        SimpleElement elem = this.getElement(elementName);
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeName = this.handleNameNS(atts.getURI(i), atts.getLocalName(i), atts.getQName(i));
            if (attributeName == null) continue;
            elem.setAttributeValue(attributeName, atts.getValue(i));
        }
        this.stack.push(elem);
    }

    private SimpleElement getElement(String elementName) {
        switch (elementName) {
            case "FileFormat": {
                return new FileFormat();
            }
            case "FileFormatHit": {
                return new FileFormatHit();
            }
            case "FileFormatCollection": {
                return new FileFormatCollection();
            }
            case "ByteSequence": {
                return new ByteSequence();
            }
            case "FFSignatureFile": {
                return new FFSignatureFile();
            }
            case "InternalSignature": {
                return new InternalSignature();
            }
            case "InternalSignatureCollection": {
                return new InternalSignatureCollection();
            }
            case "LeftFragment": {
                return new LeftFragment();
            }
            case "RightFragment": {
                return new RightFragment();
            }
            case "Shift": {
                return new Shift();
            }
            case "SubSequence": {
                return new SubSequence();
            }
        }
        return new SimpleElement();
    }

    @Override
    public void endElement(String nspace, String localname, String qname) throws SAXException {
        String elementName = this.handleNameNS(nspace, localname, qname);
        if (elementName == null) {
            return;
        }
        this.element = (SimpleElement)this.stack.pop();
        this.element.completeElementContent();
        if (!this.stack.empty()) {
            this.setProperty(elementName, this.stack.peek(), this.element);
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) {
        if (!this.stack.empty()) {
            String text = new String(ch, start, len);
            ((SimpleElement)this.stack.peek()).setText(text);
        }
    }

    private void setProperty(String name, Object target, Object value) {
        switch (target.getClass().getSimpleName()) {
            case "SubSequence": {
                this.setSubSequenceProperty((SubSequence)target, name, value);
                break;
            }
            case "ByteSequence": {
                this.setByteSequenceProperty((ByteSequence)target, name, value);
                break;
            }
            case "InternalSignature": {
                this.setInternalSignatureProperty((InternalSignature)target, name, value);
                break;
            }
            case "FFSignatureFile": {
                this.setFFSignatureFileProperty((FFSignatureFile)target, name, value);
                break;
            }
            case "InternalSignatureCollection": {
                this.setInternalSignatureCollectionProperty((InternalSignatureCollection)target, name, value);
                break;
            }
            case "FileFormat": {
                this.setFileFormatProperty((FileFormat)target, name, value);
                break;
            }
            case "FileFormatCollection": {
                this.setFileFormatCollection((FileFormatCollection)target, name, value);
                break;
            }
            default: {
                this.log.warn("Unknown target object: " + target.toString());
            }
        }
    }

    private void setFileFormatCollection(FileFormatCollection target, String name, Object value) {
        switch (name) {
            case "FileFormat": {
                target.addFileFormat((FileFormat)value);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setFileFormatProperty(FileFormat target, String name, Object value) {
        String valueText = value instanceof SimpleElement ? ((SimpleElement)value).getText().trim() : "";
        switch (name) {
            case "Extension": {
                target.setExtension(valueText);
                break;
            }
            case "InternalSignatureID": {
                target.setInternalSignatureID(valueText);
                break;
            }
            case "HasPriorityOverFileFormatID": {
                target.setHasPriorityOverFileFormatID(valueText);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setInternalSignatureCollectionProperty(InternalSignatureCollection target, String name, Object value) {
        switch (name) {
            case "InternalSignature": {
                target.addInternalSignature((InternalSignature)value);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setFFSignatureFileProperty(FFSignatureFile target, String name, Object value) {
        switch (name) {
            case "InternalSignatureCollection": {
                target.setInternalSignatureCollection((InternalSignatureCollection)value);
                break;
            }
            case "FileFormatCollection": {
                target.setFileFormatCollection((FileFormatCollection)value);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setInternalSignatureProperty(InternalSignature target, String name, Object value) {
        switch (name) {
            case "ByteSequence": {
                target.addByteSequence((ByteSequence)value);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setByteSequenceProperty(ByteSequence target, String name, Object value) {
        switch (name) {
            case "SubSequence": {
                target.addSubSequence((SubSequence)value);
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void setSubSequenceProperty(SubSequence target, String name, Object value) {
        switch (name) {
            case "LeftFragment": {
                target.addLeftFragment((LeftFragment)value);
                break;
            }
            case "RightFragment": {
                target.addRightFragment((RightFragment)value);
                break;
            }
            case "Sequence": {
                target.setSequence(((SimpleElement)value).getText().trim());
                break;
            }
            case "Shift": 
            case "DefaultShift": {
                break;
            }
            default: {
                this.logUnknownProperty(name, target);
            }
        }
    }

    private void logUnknownProperty(String propertyName, Object target) {
        this.log.warn("Unknown property " + propertyName + " requested for " + target.getClass().getSimpleName());
    }

    public SimpleElement getModel() {
        return this.element;
    }
}

