/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AppendMigratedFileDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected boolean goButtonWasClicked = false;
    protected String defaultFileChooserFolder;
    protected JButton chooseDerivedFileButton;
    protected JButton goButton;
    protected JTextField derivedFileTextField;
    protected JCheckBox keepOriginalCheckBox;
    protected JLabel messageLabel;

    protected AppendMigratedFileDialog(JFrame owner, final NodeAbstract node) {
        super(owner, I18N.translate((String)"TitleAppendMigratedFile"), true);
        this.defaultFileChooserFolder = ((SIPView)owner).getLauncherView().getDataDirectory();
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendMigratedFileDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.chooseDerivedFileButton = new JButton(PackerConstants.getImageIcon("OpenFolder.png"));
        this.chooseDerivedFileButton.setToolTipText(I18N.translate((String)"ToolTipSelectOutcome"));
        this.chooseDerivedFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendMigratedFileDialog.this.selectSourceFolderButtonClicked();
            }
        });
        this.derivedFileTextField = new JTextField();
        this.derivedFileTextField.setToolTipText(I18N.translate((String)"ToolTipOutcome"));
        this.derivedFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendMigratedFileDialog.this.derivedFileTextFieldChanged();
            }
        });
        this.derivedFileTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AppendMigratedFileDialog.this.derivedFileTextFieldChanged();
            }
        });
        this.keepOriginalCheckBox = new JCheckBox(I18N.translate((String)"LabelKeepOriginal"), ((SIPView)owner).getLauncherView().isMigrateFileKeepOriginal());
        this.keepOriginalCheckBox.setToolTipText(I18N.translate((String)"ToolTipKeepOriginal"));
        this.messageLabel = new JLabel();
        this.goButton = new JButton(PackerConstants.getImageIcon("Go.png"));
        this.goButton.setToolTipText(I18N.translate((String)"ToolTipAppendMigratedFile"));
        this.goButton.setEnabled(false);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendMigratedFileDialog.this.goButtonClicked(node);
            }
        });
        GridBagPanel gridBagPanel = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(2, 5, 0, 5));
        gridBagPanel.add((Component)new JLabel(I18N.translate((String)"LabelDerivedFile")), 0, 0, 13);
        gridBagPanel.add((Component)this.derivedFileTextField, 0, 1, 17, 2, 1.0, 0.0);
        gridBagPanel.add((Component)this.chooseDerivedFileButton, 0, 2, 17);
        gridBagPanel.add((Component)this.keepOriginalCheckBox, 1, 1, 17);
        gridBagPanel.add((Component)this.messageLabel, 2, 2, 0, 1, 17, 2, 1.0, 0.0);
        gridBagPanel.add((Component)this.goButton, 2, 2, 13);
        this.add((Component)gridBagPanel);
        this.setPreferredSize(new Dimension(500, 140));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void selectSourceFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.defaultFileChooserFolder);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectMigratedFile"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.derivedFileTextField.setText(fileChooser.getSelectedFile().getPath());
        this.defaultFileChooserFolder = fileChooser.getSelectedFile().getParent();
        this.derivedFileTextFieldChanged();
    }

    protected void derivedFileTextFieldChanged() {
        this.derivedFileTextField.setText(this.derivedFileTextField.getText().trim());
        this.enableOrDisableGoButton();
    }

    protected void enableOrDisableGoButton() {
        this.goButton.setEnabled(!this.derivedFileTextField.getText().isEmpty());
    }

    protected void goButtonClicked(NodeAbstract node) {
        this.goButtonWasClicked = true;
        this.close();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }
}

