/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.IOException;
import java.nio.charset.Charset;
import net.byteseek.io.reader.AbstractReader;
import net.byteseek.io.reader.cache.NoCache;
import net.byteseek.io.reader.windows.HardWindow;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public class StringReader
extends AbstractReader {
    private final byte[] bytes;
    private final Charset charset;

    public StringReader(String string) {
        this(string, Charset.defaultCharset());
    }

    public StringReader(String string, String charsetName) {
        this(string, Charset.forName(charsetName));
    }

    public StringReader(String string, Charset charset) {
        super(string == null ? 0 : string.length(), NoCache.NO_CACHE);
        ArgUtils.checkNullString(string, "string");
        ArgUtils.checkNullObject(charset, "charset");
        this.bytes = string.getBytes(charset);
        this.charset = charset;
    }

    @Override
    protected Window createWindow(long windowStart) throws IOException {
        return new HardWindow(this.bytes, 0L, this.bytes.length);
    }

    @Override
    public long length() throws IOException {
        return this.bytes.length;
    }

    public String getString() {
        return new String(this.bytes, this.charset);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[charset:" + this.charset + " length: " + this.bytes.length + " cache:" + this.cache + ']';
    }
}

