/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.windows;

import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public final class HardWindow
implements Window {
    private final byte[] bytes;
    private final long windowPosition;
    private final int length;

    public HardWindow(byte[] bytes, long windowPosition, int length) {
        ArgUtils.checkNullByteArray(bytes, "bytes");
        this.bytes = bytes;
        this.windowPosition = windowPosition;
        this.length = length;
    }

    @Override
    public byte getByte(int position) {
        return this.bytes[position];
    }

    @Override
    public byte[] getArray() {
        return this.bytes;
    }

    @Override
    public long getWindowPosition() {
        return this.windowPosition;
    }

    @Override
    public long getWindowEndPosition() {
        return this.windowPosition + (long)this.length - 1L;
    }

    @Override
    public long getNextWindowPosition() {
        return this.windowPosition + (long)this.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bytes length: " + this.bytes.length + " window length:" + this.length + " window pos:" + this.windowPosition + ']';
    }
}

