/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import net.byteseek.matcher.multisequence.MultiSequenceMatcher;

public final class WuManberUtils {
    private WuManberUtils() {
    }

    public static int suggestBlockSize(MultiSequenceMatcher matcher) {
        return WuManberUtils.suggestBlockSize(256, matcher);
    }

    public static int suggestBlockSize(int alphabetSize, MultiSequenceMatcher matcher) {
        return WuManberUtils.suggestBlockSize(alphabetSize, matcher.getMinimumLength(), matcher.getSequenceMatchers().size());
    }

    public static int suggestBlockSize(int alphabetSize, int minimumLength, int numberOfSequences) {
        return WuManberUtils.getSafeBlockSize(minimumLength, (int)Math.ceil(WuManberUtils.calculatePossibleBlockSize(alphabetSize, minimumLength, numberOfSequences)));
    }

    public static int getSafeBlockSize(int minimumLength, int possibleBlockSize) {
        int notGreaterThanMinimumLength = minimumLength < possibleBlockSize ? minimumLength : possibleBlockSize;
        return notGreaterThanMinimumLength > 1 ? notGreaterThanMinimumLength : 1;
    }

    public static double calculatePossibleBlockSize(int alphabetSize, int minimumLength, int numberOfSequences) {
        return WuManberUtils.logOfBase(alphabetSize, 2 * minimumLength * numberOfSequences);
    }

    private static double logOfBase(int base, int number) {
        return Math.log(number) / Math.log(base);
    }
}

