/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class DDResolutionBox
extends JP2Box {
    public DDResolutionBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        if (!(this._parentBox instanceof ResolutionBox)) {
            this.wrongBoxContext();
            return false;
        }
        ResolutionBox rb = (ResolutionBox)this._parentBox;
        ArrayList<Property> vresList = new ArrayList<Property>(3);
        ArrayList<Property> hresList = new ArrayList<Property>(3);
        vresList.add(new Property("Numerator", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm))));
        vresList.add(new Property("Denominator", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm))));
        hresList.add(new Property("Numerator", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm))));
        hresList.add(new Property("Denominator", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm))));
        vresList.add(new Property("Exponent", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readSignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module))));
        hresList.add(new Property("Exponent", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readSignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module))));
        Property hres = new Property("HorizResolution", PropertyType.PROPERTY, PropertyArity.LIST, hresList);
        Property vres = new Property("VertResolution", PropertyType.PROPERTY, PropertyArity.LIST, vresList);
        Property[] topProps = new Property[]{hres, vres};
        this._module.addProperty(new Property("DefaultDisplayResolution", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)topProps));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Default Display Resolution Box";
    }
}

