/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.windows.Window;

public final class TopAndTailStreamCache
extends AbstractFreeNotificationCache {
    final long topCacheBytes;
    final long tailCacheBytes;
    final TLongObjectMap<Window> cache;
    final List<Window> tailEntries;
    long lastSeenPosition;

    public TopAndTailStreamCache(long topTailBytes) {
        this(topTailBytes, topTailBytes);
    }

    public TopAndTailStreamCache(long topBytes, long tailBytes) {
        this.topCacheBytes = topBytes;
        this.tailCacheBytes = tailBytes;
        this.cache = new TLongObjectHashMap();
        this.tailEntries = new ArrayList<Window>();
    }

    @Override
    public Window getWindow(long position) {
        return (Window)this.cache.get(position);
    }

    @Override
    public void addWindow(Window window) throws IOException {
        long windowPos = window.getWindowPosition();
        this.cache.put(windowPos, (Object)window);
        if (windowPos >= this.topCacheBytes) {
            Window tailEntry;
            int i;
            long tailCacheStart = window.getNextWindowPosition() - this.tailCacheBytes;
            int numTailEntries = this.tailEntries.size();
            int removeEntry = 0;
            for (i = 0; i < numTailEntries && (tailEntry = this.tailEntries.get(i)).getNextWindowPosition() <= tailCacheStart; ++i) {
                removeEntry = i + 1;
            }
            if (removeEntry > 0) {
                for (i = 0; i < removeEntry; ++i) {
                    Window toRemove = this.tailEntries.get(i);
                    this.cache.remove(toRemove.getWindowPosition());
                    this.notifyWindowFree(toRemove, this);
                }
                this.tailEntries.subList(0, removeEntry).clear();
            }
            this.tailEntries.add(window);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.tailEntries.clear();
    }
}

