/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.byteseek.matcher.bytes.AbstractByteMatcher;
import net.byteseek.matcher.bytes.AllBitmaskMatcher;
import net.byteseek.matcher.bytes.AnyBitmaskMatcher;
import net.byteseek.matcher.bytes.AnyByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.ByteRangeMatcher;
import net.byteseek.matcher.bytes.InvertedByteMatcher;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.matcher.bytes.OneByteMatcher;
import net.byteseek.matcher.bytes.SetBinarySearchMatcher;
import net.byteseek.matcher.bytes.SetBitsetMatcher;
import net.byteseek.matcher.bytes.TwoByteMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class OptimalByteMatcherFactory
implements ByteMatcherFactory {
    public static ByteMatcherFactory FACTORY = new OptimalByteMatcherFactory();
    private static final int BINARY_SEARCH_THRESHOLD = 16;

    @Override
    public ByteMatcher create(Collection<Byte> bytes) {
        return this.create(bytes, false);
    }

    @Override
    public ByteMatcher create(Collection<Byte> bytes, boolean matchInverse) {
        Set<Byte> invertedValues;
        ArgUtils.checkNullOrEmptyCollection(bytes, "bytes");
        LinkedHashSet<Byte> uniqueValues = new LinkedHashSet<Byte>(bytes);
        Set<Byte> values = matchInverse ? ByteUtils.invertedSet(uniqueValues) : uniqueValues;
        ByteMatcher result = this.getSimpleCases(values);
        if (result == null && (result = this.getInvertibleCases(values, false)) == null && (result = this.getInvertibleCases(invertedValues = matchInverse ? uniqueValues : ByteUtils.invertedSet(uniqueValues), true)) == null) {
            result = new SetBitsetMatcher(uniqueValues, matchInverse);
        }
        return result;
    }

    private ByteMatcher getInvertibleCases(Set<Byte> bytes, boolean isInverted) {
        ByteMatcher result = this.getBitmaskMatchers(bytes, isInverted);
        if (result == null && (result = this.getRangeMatchers(bytes, isInverted)) == null) {
            result = this.getBinarySearchMatcher(bytes, isInverted);
        }
        return result;
    }

    private ByteMatcher getSimpleCases(Set<Byte> values) {
        AbstractByteMatcher result = null;
        block0 : switch (values.size()) {
            case 0: {
                result = new AnyBitmaskMatcher(0, false);
                break;
            }
            case 1: {
                Iterator<Byte> byteValue = values.iterator();
                result = OneByteMatcher.valueOf(byteValue.next());
                break;
            }
            case 2: {
                result = new TwoByteMatcher(values);
                break;
            }
            case 255: {
                for (int byteValue = 0; byteValue < 256; ++byteValue) {
                    if (values.contains((byte)byteValue)) continue;
                    result = new InvertedByteMatcher((byte)byteValue);
                    break block0;
                }
                break;
            }
            case 256: {
                result = new AnyByteMatcher();
            }
        }
        return result;
    }

    private ByteMatcher getBitmaskMatchers(Set<Byte> values, boolean isInverted) {
        InvertibleMatcher result = null;
        Byte bitmask = ByteUtils.getAllBitMaskForBytes(values);
        if (bitmask != null) {
            result = new AllBitmaskMatcher(bitmask, isInverted);
        } else {
            bitmask = ByteUtils.getAnyBitMaskForBytes(values);
            if (bitmask != null) {
                result = new AnyBitmaskMatcher(bitmask, isInverted);
            }
        }
        return result;
    }

    private ByteMatcher getRangeMatchers(Set<Byte> values, boolean isInverted) {
        ByteRangeMatcher result = null;
        List<Integer> byteValues = OptimalByteMatcherFactory.getSortedByteValues(values);
        int lastValuePosition = byteValues.size() - 1;
        int firstValue = byteValues.get(0);
        int lastValue = byteValues.get(lastValuePosition);
        if (lastValue - firstValue == lastValuePosition) {
            result = new ByteRangeMatcher(firstValue, lastValue, isInverted);
        }
        return result;
    }

    private ByteMatcher getBinarySearchMatcher(Set<Byte> values, boolean isInverted) {
        SetBinarySearchMatcher result = null;
        if (values.size() < 16) {
            result = new SetBinarySearchMatcher(values, isInverted);
        }
        return result;
    }

    private static List<Integer> getSortedByteValues(Set<Byte> byteSet) {
        ArrayList<Integer> sortedByteValues = new ArrayList<Integer>();
        for (Byte b : byteSet) {
            sortedByteValues.add(b & 0xFF);
        }
        Collections.sort(sortedByteValues);
        return sortedByteValues;
    }
}

