/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;

public class ExtendedAttributes
implements Attributes {
    private static final String XMLNS_PREFIX = "xmlns";
    private Attributes basicAttributes = null;
    private List<Map.Entry<String, String>> extAttrList = null;

    public ExtendedAttributes() {
    }

    public ExtendedAttributes(Attributes basicAttributes) {
        this();
        this.basicAttributes = basicAttributes;
    }

    public void addExtendedAttributes(List<Map.Entry<String, String>> extAttrList) {
        this.extAttrList = extAttrList;
    }

    @Override
    public int getLength() {
        return this.getLengthBasic() + this.getLengthExtended();
    }

    private int getLengthExtended() {
        return this.extAttrList == null ? 0 : this.extAttrList.size();
    }

    private int getLengthBasic() {
        return this.basicAttributes == null ? 0 : this.basicAttributes.getLength();
    }

    @Override
    public String getQName(int paramInt) {
        if (paramInt < this.getLengthBasic()) {
            return this.basicAttributes.getQName(paramInt);
        }
        String qName = this.extAttrList.get(paramInt - this.getLengthBasic()).getKey();
        return XMLNS_PREFIX + (StringUtils.isBlank((String)qName) ? "" : ":" + qName);
    }

    @Override
    public String getValue(int paramInt) {
        String val = null;
        val = paramInt < this.getLengthBasic() ? this.basicAttributes.getValue(paramInt) : this.extAttrList.get(paramInt - this.getLengthBasic()).getValue();
        return StringEscapeUtils.escapeXml((String)val);
    }

    @Override
    public String getURI(int paramInt) {
        return null;
    }

    @Override
    public String getLocalName(int paramInt) {
        return null;
    }

    @Override
    public String getType(int paramInt) {
        return null;
    }

    @Override
    public int getIndex(String paramString1, String paramString2) {
        return 0;
    }

    @Override
    public int getIndex(String paramString) {
        return 0;
    }

    @Override
    public String getType(String paramString1, String paramString2) {
        return null;
    }

    @Override
    public String getType(String paramString) {
        return null;
    }

    @Override
    public String getValue(String paramString1, String paramString2) {
        return null;
    }

    @Override
    public String getValue(String paramString) {
        return null;
    }
}

