/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.sharedsession;

import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SessionHelperCleaner
extends TimerTask {
    private static final Logger logger = Logger.getLogger(SessionHelperCleaner.class);

    public static void start() {
        Timer timer = new Timer("SessionHelperCleaner");
        timer.scheduleAtFixedRate((TimerTask)new SessionHelperCleaner(), 600000L, 1800000L);
    }

    @Override
    public void run() {
        logger.log((Priority)Level.INFO, (Object)"begin");
        long last = System.currentTimeMillis() - 5400000L;
        ArrayList<String> ids = new ArrayList<String>(SessionHelper.sharedSessions.keySet());
        int nb = 0;
        for (String id : ids) {
            WeakReference<SessionHelper.SharedSession> weakReference = SessionHelper.sharedSessions.get(id);
            SessionHelper.SharedSession sSession = weakReference == null ? null : (SessionHelper.SharedSession)weakReference.get();
            if (sSession == null || sSession.lastUse >= last) continue;
            ++nb;
            logger.log((Priority)Level.INFO, (Object)(id + " last use: " + new Date(sSession.lastUse)));
            logger.log((Priority)Level.INFO, (Object)(id + " last: " + new Date(last)));
            logger.log((Priority)Level.INFO, (Object)("old session is present: " + id + " (   sessionContexts:   " + sSession.sessionContexts + ",   attributes:   " + sSession.attributes + ",   last:  " + new Date(sSession.lastUse) + "   )"));
        }
        logger.log((Priority)Level.INFO, (Object)("number of shared sessions: " + SessionHelper.sharedSessions.size() + "."));
        logger.log((Priority)Level.INFO, (Object)("number of old sessions: " + nb + "."));
        logger.log((Priority)Level.INFO, (Object)"end");
    }
}

