/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.warc;

import org.jwat.common.Digest;

public class WarcDigest
extends Digest {
    protected WarcDigest() {
    }

    protected WarcDigest(String algorithm, String digestValue) {
        this.algorithm = algorithm;
        this.digestString = digestValue;
    }

    public static WarcDigest parseWarcDigest(String labelledDigest) {
        if (labelledDigest == null || labelledDigest.length() == 0) {
            return null;
        }
        int cIdx = labelledDigest.indexOf(58);
        if (cIdx != -1) {
            String algorithm = labelledDigest.substring(0, cIdx).trim().toLowerCase();
            String digestValue = labelledDigest.substring(cIdx + 1).trim();
            if (algorithm.length() > 0 && digestValue.length() > 0) {
                return new WarcDigest(algorithm, digestValue);
            }
        }
        return null;
    }

    public static WarcDigest createWarcDigest(String algorithm, byte[] digestBytes, String encoding, String digestValue) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("'algorithm' is empty or null");
        }
        if (digestBytes == null || digestBytes.length == 0) {
            throw new IllegalArgumentException("'digestBytes' is empty or null");
        }
        if (encoding == null || encoding.length() == 0) {
            throw new IllegalArgumentException("'encoding' is empty or null");
        }
        if (digestValue == null || digestValue.length() == 0) {
            throw new IllegalArgumentException("'digestValue' is empty or null");
        }
        WarcDigest digest = new WarcDigest();
        digest.algorithm = algorithm.toLowerCase();
        digest.digestBytes = digestBytes;
        digest.encoding = encoding.toLowerCase();
        digest.digestString = digestValue;
        return digest;
    }

    public String toString() {
        return this.algorithm + ":" + this.digestString;
    }

    public String toStringFull() {
        return this.algorithm + ":" + this.encoding + ":" + this.digestString;
    }
}

