/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import bsh.EvalError;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.CSVMetadataValue;
import ch.docuteam.darc.mdconfig.LevelMetadataElement;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.util.XMLUtil;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.ToolTipText;
import java.lang.reflect.InvocationTargetException;

public class MetadataElementInstance
implements ToolTipText {
    private static final String KeyStartString = "${";
    private static final String KeyEndString = "}";
    private final LevelMetadataElement levelMetadataElement;
    private final NodeAbstract node;
    private final int i;
    private String value;

    public MetadataElementInstance(LevelMetadataElement lme, NodeAbstract node, String value, int i) {
        this.levelMetadataElement = lme;
        this.node = node;
        this.i = i;
        this.value = value;
    }

    public String getName() {
        return this.levelMetadataElement.getId();
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        if (this.getLevelMetadataElement().getMetadataElement().isValueTypeRDFAndNotNull(this.value)) {
            return this.getLevelMetadataElement().getMetadataElement().getRDFLabel(this.value);
        }
        if (this.getLevelMetadataElement().getMetadataElement().isValueTypeCSVAndNotNull(this.value)) {
            return this.getLevelMetadataElement().getMetadataElement().getCSVLabel(this.value);
        }
        if (this.value == null || !this.value.contains(KeyStartString) || !this.value.contains(KeyEndString)) {
            return this.value;
        }
        int keyStartIndex = this.value.indexOf(KeyStartString);
        int keyEndIndex = this.value.indexOf(KeyEndString, keyStartIndex);
        if (keyEndIndex == -1) {
            return this.value;
        }
        return this.value.substring(0, keyStartIndex) + this.value.substring(keyEndIndex + KeyEndString.length());
    }

    public void setValue(String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        this.setValueAsString(XMLUtil.sanitizeXmlChars(value));
    }

    public void setValue_force(String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        if (this.value == null && value == null) {
            return;
        }
        if (this.value == null && value.isEmpty()) {
            return;
        }
        if (value != null && value.equals(this.value)) {
            return;
        }
        this.levelMetadataElement.setValueInNode_NoCheck(this.i, value, this.node);
        this.value = this.levelMetadataElement.getValueFromNode(this.i, this.node);
    }

    private void setValueAsString(String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, LevelMetadataElementIsReadOnly {
        if (this.value == null && value == null) {
            return;
        }
        if (value != null && !value.equals(this.value)) {
            this.levelMetadataElement.setValueInNode(this.i, value, this.node);
            this.value = this.levelMetadataElement.getValueFromNode(this.i, this.node);
        } else if (value == null) {
            this.levelMetadataElement.setValueInNode(this.i, "", this.node);
            this.value = null;
        }
    }

    public void setValue(RDFMetadataValue value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, LevelMetadataElementIsReadOnly {
        this.setValueAsString(value.getSubjectURI());
    }

    public void setValue(CSVMetadataValue value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, LevelMetadataElementIsReadOnly {
        this.setValueAsString(value.getKey());
    }

    public void initializeValueIfNecessary() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, EvalError, MetadataElementValidatorException, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException {
        String defaultValue;
        if ((this.value == null || this.value.isEmpty()) && (defaultValue = this.getLevelMetadataElement().getDefaultValueFromNode(this.node)) != null) {
            this.setValue_force(defaultValue);
        }
    }

    public int getIndex() {
        return this.i;
    }

    public LevelMetadataElement getLevelMetadataElement() {
        return this.levelMetadataElement;
    }

    public String getAttributesString() {
        StringBuilder s = new StringBuilder();
        s.append(this.isMandatory() ? (this.value == null || this.value.isEmpty() ? "!" : "*") : (this.isAlwaysDisplayed() ? "O" : " "));
        s.append(this.isRepeatable() ? "+" : " ");
        s.append(this.isReadOnly() ? "X" : " ");
        return s.toString();
    }

    public boolean isMandatory() {
        return this.levelMetadataElement.isMandatory();
    }

    public boolean isAlwaysDisplayed() {
        return this.levelMetadataElement.isAlwaysDisplayed();
    }

    public boolean isRepeatable() {
        return this.levelMetadataElement.isRepeatable();
    }

    public boolean isReadOnly() {
        return this.levelMetadataElement.isReadOnly();
    }

    public boolean keepInTemplate() {
        return this.levelMetadataElement.keepInTemplate();
    }

    public boolean isToBeDisplayed() {
        return this.isMandatoryOrSet() || this.levelMetadataElement.isAlwaysDisplayed();
    }

    public boolean isMandatoryOrSet() {
        return this.levelMetadataElement.isMandatory() || this.value != null;
    }

    public boolean isMandatoryButNotSet() {
        return this.levelMetadataElement.isMandatory() && (this.value == null || this.value.isEmpty());
    }

    public boolean isMandatoryOrEmpty() {
        return this.levelMetadataElement.isMandatory() || this.value != null && this.value.isEmpty();
    }

    public boolean canBeDeleted() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.levelMetadataElement.canDeleteOneInstanceFromNode(this.node);
    }

    public String getToolTipText() {
        return this.levelMetadataElement.getMetadataElement().getToolTipText();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetadataElement [").append(this.getAttributesString()).append(this.levelMetadataElement.isRepeatable() ? Integer.valueOf(this.i) : " ").append(":").append(this.levelMetadataElement.getId()).append("='").append(this.value).append("']");
        return builder.toString();
    }

    public void deleteMetadataElementInstanceFromNode() {
        try {
            this.levelMetadataElement.deleteMetadataElementInstanceFromNodeWithoutCheck(this.node, this);
            this.value = null;
        }
        catch (MetadataElementCantDeleteException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Logger.error((Object)"deleteMetadataElementInstanceFromNode failed due to: ", (Throwable)e);
        }
    }
}

