/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public abstract class IntegerCastFunction
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (XMLDatatypeUtil.isNumericDatatype((IRI)datatype)) {
                String lexicalValue;
                if (XMLDatatypeUtil.isIntegerDatatype((IRI)datatype) && this.isValidForDatatype(lexicalValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel()))) {
                    return valueFactory.createLiteral(lexicalValue, this.getXsdDatatype());
                }
                BigInteger integerValue = null;
                integerValue = XSD.DECIMAL.equals((Object)datatype) || XMLDatatypeUtil.isFloatingPointDatatype((IRI)datatype) ? literal.decimalValue().toBigInteger() : literal.integerValue();
                try {
                    return this.createTypedLiteral(valueFactory, integerValue).orElseThrow(() -> this.typeError((Value)literal, null));
                }
                catch (ArithmeticException | NumberFormatException e) {
                    throw this.typeError((Value)literal, e);
                }
            }
            if (datatype.equals((Object)XSD.BOOLEAN)) {
                try {
                    return this.createTypedLiteral(valueFactory, literal.booleanValue()).orElseThrow(() -> this.typeError((Value)literal, null));
                }
                catch (IllegalArgumentException e) {
                    throw this.typeError((Value)literal, e);
                }
            }
        }
        throw this.typeError(value, null);
    }

    protected abstract Optional<Literal> createTypedLiteral(ValueFactory var1, BigInteger var2) throws ArithmeticException;

    protected Optional<Literal> createTypedLiteral(ValueFactory vf, boolean booleanValue) {
        return Optional.of(vf.createLiteral(booleanValue ? "1" : "0", this.getXsdDatatype()));
    }
}

