/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import java.io.InputStream;
import java.net.URL;
import org.xml.sax.InputSource;

public class DTDMapper {
    private static final String xhtml1Frameset = "-//W3C//DTD XHTML 1.0 FRAMESET//EN";
    private static final String xhtml1Strict = "-//W3C//DTD XHTML 1.0 STRICT//EN";
    private static final String xhtml1Transitional = "-//W3C//DTD XHTML 1.0 TRANSITIONAL//EN";
    private static final String xhtml11 = "-//W3C//DTD XHTML 1.1//EN";
    private static final String latin1Ent = "-//W3C//ENTITIES LATIN 1 FOR XHTML//EN";
    private static final String specialEnt = "-//W3C//ENTITIES SPECIAL FOR XHTML//EN";
    private static final String symbolEnt = "-//W3C//ENTITIES SYMBOLS FOR XHTML//EN";

    public static InputSource publicIDToFile(String publicID) {
        URL dtdURL;
        String filename = null;
        if (publicID == null) {
            return null;
        }
        if (xhtml1Frameset.equals(publicID = publicID.toUpperCase())) {
            filename = "xhtml1-frameset.dtd";
        } else if (xhtml1Strict.equals(publicID)) {
            filename = "xhtml1-strict.dtd";
        } else if (xhtml1Transitional.equals(publicID)) {
            filename = "xhtml1-transitional.dtd";
        } else if (xhtml11.equals(publicID)) {
            filename = "xhtml11-flat.dtd";
        } else if (latin1Ent.equals(publicID)) {
            filename = "xhtml-lat1.ent";
        } else if (specialEnt.equals(publicID)) {
            filename = "xhtml-special.ent";
        } else if (symbolEnt.equals(publicID)) {
            filename = "xhtml-symbol.ent";
        }
        if (filename != null && (dtdURL = DTDMapper.class.getResource(filename)) != null) {
            try {
                InputStream strm = dtdURL.openStream();
                return new InputSource(strm);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isXHTMLDTD(String publicID) {
        if (publicID == null) {
            return false;
        }
        return xhtml1Frameset.equals(publicID = publicID.toUpperCase()) || xhtml1Strict.equals(publicID) || xhtml1Transitional.equals(publicID) || xhtml11.equals(publicID);
    }

    public static String getXHTMLVersion(String publicID) {
        if (!DTDMapper.isXHTMLDTD(publicID = publicID.toUpperCase())) {
            return null;
        }
        if (xhtml11.equals(publicID)) {
            return "1.1";
        }
        return "1.0";
    }
}

