/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.reader.KeyValueReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataReader {
    private static final Logger logger = LoggerFactory.getLogger(MetadataReader.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private MetadataReader() {
    }

    public static List<AbstractMap.SimpleImmutableEntry<String, String>> readBagMetadata(Path rootDir, Charset encoding) throws IOException, InvalidBagMetadataException {
        Path packageInfoFile;
        logger.info(messages.getString("attempting_read_metadata"));
        List<AbstractMap.SimpleImmutableEntry<String, String>> metadata = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
        Path bagInfoFile = rootDir.resolve("bag-info.txt");
        if (Files.exists(bagInfoFile, new LinkOption[0])) {
            logger.debug(messages.getString("found_metadata_file"), (Object)bagInfoFile);
            metadata = KeyValueReader.readKeyValuesFromFile(bagInfoFile, ":", encoding);
        }
        if (Files.exists(packageInfoFile = rootDir.resolve("package-info.txt"), new LinkOption[0])) {
            logger.debug(messages.getString("found_metadata_file"), (Object)packageInfoFile);
            metadata = KeyValueReader.readKeyValuesFromFile(packageInfoFile, ":", encoding);
        }
        return metadata;
    }
}

