/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.VariableTextFieldDictionary;
import org.icepdf.core.util.Library;

public class TextFieldDictionary
extends VariableTextFieldDictionary {
    public static final Name MAX_LENGTH_KEY = new Name("MaxLen");
    public static final int MULTILINE_BIT_FLAG = 4096;
    public static final int PASSWORD_BIT_FLAG = 8192;
    public static final int FILE_SELECT_BIT_FLAG = 0x100000;
    public static final int TEXT_DO_NOT_SPELL_CHECK_BIT_FLAG = 0x100000;
    public static final int DO_NOT_SCROLL_BIT_FLAG = 0x800000;
    public static final int COMB_BIT_FLAG = 0x1000000;
    public static final int RICH_TEXT_BIT_FLAG = 0x2000000;
    protected TextFieldType textFieldType;
    protected int maxLength = 0;

    public TextFieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        int flags;
        Object value = library.getObject(entries, MAX_LENGTH_KEY);
        if (value != null && value instanceof Number) {
            this.maxLength = ((Number)value).intValue();
        }
        this.textFieldType = ((flags = this.getFlags()) & 0x1000) == 4096 ? TextFieldType.TEXT_AREA : ((flags & 0x2000) == 8192 ? TextFieldType.TEXT_PASSWORD : ((flags & 0x100000) == 0x100000 ? TextFieldType.FILE_SELECT : TextFieldType.TEXT_INPUT));
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public TextFieldType getTextFieldType() {
        return this.textFieldType;
    }

    public boolean isMultiLine() {
        return (this.getFlags() & 0x1000) == 4096;
    }

    public boolean isFileSelect() {
        return (this.getFlags() & 0x100000) == 0x100000;
    }

    public boolean isDoNotScroll() {
        return (this.getFlags() & 0x800000) == 0x800000;
    }

    public boolean isComb() {
        return (this.getFlags() & 0x1000000) == 0x1000000;
    }

    public boolean isRichText() {
        return (this.getFlags() & 0x2000000) == 0x2000000;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextFieldType {
        TEXT_INPUT,
        TEXT_AREA,
        TEXT_PASSWORD,
        FILE_SELECT;

    }
}

