/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

import ch.docuteam.mapping.csv.CsvImportError;
import ch.docuteam.mapping.csv.CsvImportException;
import ch.docuteam.mapping.csv.CsvImportWarning;
import ch.docuteam.tools.translations.I18N;
import java.util.List;
import java.util.stream.Collectors;

public class ImportResult {
    private final boolean success;
    private final List<CsvImportWarning> warnings;
    private final CsvImportException exception;
    private final CsvImportError error;
    private final Object[] additionalErrorObjects;

    public ImportResult(boolean success, List<CsvImportWarning> warnings, CsvImportError error, Object ... additionalErrorObjects) {
        this.success = success;
        this.warnings = warnings;
        this.error = error;
        this.additionalErrorObjects = additionalErrorObjects;
        this.exception = null;
    }

    private ImportResult(CsvImportException exception) {
        this.success = false;
        this.warnings = List.of();
        this.error = exception.getError();
        this.additionalErrorObjects = exception.getAdditionalObjects();
        this.exception = exception;
    }

    static ImportResult fromCSVImportException(CsvImportException importException) {
        return new ImportResult(importException);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<CsvImportWarning> getWarnings() {
        return this.warnings;
    }

    public String getSuccessMessagesWithPotentialWarnings() {
        String successMessage = I18N.translate((String)"ImportCsvSuccess");
        if (this.warnings.isEmpty()) {
            return successMessage;
        }
        String formattedWarnings = this.warnings.stream().map(warning -> I18N.translate((String)warning.getWarningType().getMessageKey(), (Object[])new Object[]{warning.getNode(), warning.getProperty(), warning.getValue()})).collect(Collectors.joining(System.lineSeparator()));
        String warningsHeader = I18N.translate((String)"ImportCsvWarningHeader");
        return String.join((CharSequence)System.lineSeparator(), successMessage, warningsHeader, formattedWarnings);
    }

    public CsvImportError getError() {
        return this.error;
    }

    public Object[] getAdditionalErrorObjects() {
        return this.additionalErrorObjects;
    }

    public String getUntranslatedErrorMessage() {
        return this.error.getFormattedMessage(this.additionalErrorObjects);
    }

    public CsvImportException getException() {
        return this.exception;
    }
}

