/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIfFileExistsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CheckIfFileExistsTask.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private final transient Path file;
    private final transient Set<Path> missingFiles;
    private final transient CountDownLatch latch;

    public CheckIfFileExistsTask(Path file, Set<Path> missingFiles, CountDownLatch latch) {
        this.file = file;
        this.latch = latch;
        this.missingFiles = missingFiles;
    }

    @Override
    public void run() {
        boolean existsNormalized = this.existsNormalized();
        boolean fileExists = Files.exists(this.file, new LinkOption[0]);
        if (!fileExists) {
            if (existsNormalized) {
                logger.warn(messages.getString("different_normalization_on_filesystem_warning"), (Object)this.file);
            } else {
                this.missingFiles.add(this.file);
            }
        }
        this.latch.countDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsNormalized() {
        String normalizedFile = Normalizer.normalize(this.file.toString(), Normalizer.Form.NFD);
        Path parent = this.file.getParent();
        if (parent == null) return false;
        try (DirectoryStream<Path> files = Files.newDirectoryStream(parent);){
            Path fileToCheck;
            String normalizedFileToCheck;
            Iterator<Path> iterator = files.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!normalizedFile.equals(normalizedFileToCheck = Normalizer.normalize((fileToCheck = iterator.next()).toString(), Normalizer.Form.NFD)));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(messages.getString("error_reading_normalized_file"), new Object[]{parent, normalizedFile, e});
        }
        return false;
    }
}

