/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCountAndTotalSizeVistor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(FileCountAndTotalSizeVistor.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private transient long totalSize;
    private transient long count;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (dir.endsWith(Paths.get(".bagit", new String[0]))) {
            logger.debug(messages.getString("skipping_ignored_directory"), (Object)dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        ++this.count;
        long size = Files.size(path);
        logger.debug(messages.getString("file_size_in_bytes"), (Object)path, (Object)size);
        this.totalSize += size;
        return FileVisitResult.CONTINUE;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

