/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverterJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

final class DynamicByteArray
extends ByteArray {
    static final int INITIAL_BLOCKS = 16;
    static final int GROWTH_FACTOR = 8;
    private final BlockSource source;
    private final long blockSize;
    private byte[][] blocks = new byte[16][];
    protected long length = 0L;
    private final int[] out_bytesRead = new int[1];
    private static final char[] ISO_LATIN_1_TO_JAVA;
    private static final char[] WE8DEC_TO_JAVA;
    private static final char[] WE8MSWIN1252_TO_JAVA;
    private int globalBlockIndex = -1;
    private int globalByteIndex = -1;
    private int globalRemaining = -1;
    private int globalBlockSize = -1;
    private byte[] globalBytes = null;
    private static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    @Override
    long length() {
        return this.length;
    }

    static DynamicByteArray createDynamicByteArray(BlockSource blockSource) {
        return new DynamicByteArray(blockSource);
    }

    private DynamicByteArray(BlockSource blockSource) {
        assert (blockSource != null) : "source is null";
        this.source = blockSource;
        this.blockSize = blockSource.getBlockSize();
    }

    private void grow() {
        byte[][] byArrayArray = new byte[this.blocks.length * 8][];
        System.arraycopy(this.blocks, 0, byArrayArray, 0, this.blocks.length);
        this.blocks = byArrayArray;
    }

    final int unmarshalCLR(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        return this.unmarshalCLR(t4CMAREngine, Integer.MAX_VALUE);
    }

    final int unmarshalCLR(T4CMAREngine t4CMAREngine, int n2) throws SQLException, IOException {
        t4CMAREngine.unmarshalCLR(this, this.position, this.out_bytesRead, n2, 0);
        this.position += (long)this.out_bytesRead[0];
        this.length = Math.max(this.length, this.position + 1L);
        return this.out_bytesRead[0];
    }

    final long unmarshalBuffer(T4CMAREngine t4CMAREngine, long l2, int n2) throws SQLException, IOException {
        assert (l2 >= 0L) : "offset: " + l2;
        int n3 = (int)(l2 / this.blockSize);
        int n4 = (int)(l2 % this.blockSize);
        l2 += (long)n2;
        while (n2 > 0) {
            while (n3 >= this.blocks.length) {
                this.grow();
            }
            if (this.blocks[n3] == null) {
                this.blocks[n3] = this.source.get();
            }
            int n5 = Math.min(n2, (int)this.blockSize - n4);
            t4CMAREngine.unmarshalNBytes(this.blocks[n3], n4, n5);
            n4 = 0;
            ++n3;
            n2 -= n5;
        }
        return l2;
    }

    final int unmarshalCLRforREFS(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        byte[] byArray = t4CMAREngine.unmarshalCLRforREFS();
        if (byArray == null) {
            return 0;
        }
        this.put(byArray);
        return byArray.length;
    }

    void copyLeft(long l2, int n2) {
        int n3;
        assert (l2 >= this.position && n2 >= 0 && this.length >= this.position + (long)n2) : "this.position: " + this.position + " this.length: " + this.length + " srcOffset: " + l2 + " length: " + n2;
        if (l2 == this.position || n2 == 0) {
            this.position += (long)n2;
            return;
        }
        assert (l2 > this.position && n2 > 0);
        int n4 = (int)(this.position / this.blockSize);
        int n5 = (int)(this.position % this.blockSize);
        int n6 = (int)(l2 / this.blockSize);
        int n7 = (int)(l2 % this.blockSize);
        int n8 = (int)this.blockSize;
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            n3 = Math.min(i2, Math.min(n8 - n7, n8 - n5));
            System.arraycopy(this.blocks[n6], n7, this.blocks[n4], n5, n3);
            if ((n7 += n3) == n8) {
                ++n6;
                n7 = 0;
            }
            if ((n5 += n3) != n8) continue;
            ++n4;
            n5 = 0;
        }
        this.position += (long)n2;
    }

    @Override
    void put(long l2, byte by) {
        assert (l2 >= 0L) : "index: " + l2;
        int n2 = (int)(l2 / this.blockSize);
        int n3 = (int)(l2 % this.blockSize);
        while (n2 >= this.blocks.length) {
            this.grow();
        }
        if (this.blocks[n2] == null) {
            this.blocks[n2] = this.source.get();
        }
        this.blocks[n2][n3] = by;
        this.length = Math.max(this.length, l2 + 1L);
    }

    @Override
    byte get(long l2) {
        assert (l2 >= 0L && l2 < this.length);
        int n2 = (int)(l2 / this.blockSize);
        int n3 = (int)(l2 % this.blockSize);
        assert (this.blocks.length >= n2 && this.blocks[n2] != null) : "invalid read--blocks.length: " + this.blocks.length + " blockIndex: " + n2 + (n2 < this.blocks.length ? " blocks[" + n2 + "]: " + this.blocks[n2] : "");
        return this.blocks[n2][n3];
    }

    @Override
    void put(long l2, byte[] byArray, int n2, int n3) {
        assert (byArray != null) : "src is null";
        assert (l2 >= 0L && n2 + n3 <= byArray.length) : "offset: " + l2 + " src.length: " + byArray.length + " srcOffset: " + n2 + " length: " + n3;
        int n4 = (int)(l2 / this.blockSize);
        int n5 = (int)(l2 % this.blockSize);
        int n6 = (int)this.blockSize;
        int n7 = n3;
        while (true) {
            if (n4 >= this.blocks.length) {
                this.grow();
                continue;
            }
            if (this.blocks[n4] == null) {
                this.blocks[n4] = this.source.get();
            }
            System.arraycopy(byArray, n2 + n3 - n7, this.blocks[n4], n5, Math.min(n6 - n5, n7));
            ++n4;
            n5 = 0;
            if ((n7 -= n6 - n5) <= 0) break;
        }
        this.length = Math.max(this.length, l2 + (long)n3 + 1L);
    }

    @Override
    void get(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 >= 0L && l2 + (long)n3 <= this.length && n2 >= 0 && n2 + n3 <= byArray.length) : " offset: " + l2 + " this.length: " + this.length + " destOffset: " + n2 + " length: " + n3;
        int n4 = (int)(l2 / this.blockSize);
        int n5 = (int)(l2 % this.blockSize);
        int n6 = (int)this.blockSize;
        int n7 = n3;
        do {
            System.arraycopy(this.blocks[n4], n5, byArray, n2 + n3 - n7, Math.min(n6 - n5, n7));
            ++n4;
        } while ((n7 -= n6 - (n5 = 0)) > 0);
    }

    @Override
    void free() {
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            if (this.blocks[i2] == null) continue;
            this.source.put(this.blocks[i2]);
            this.blocks[i2] = null;
        }
        this.position = 0L;
        this.length = 0L;
    }

    @Override
    long updateChecksum(long l2, int n2, CRC64 cRC64, long l3) {
        int n3 = (int)(l2 / this.blockSize);
        int n4 = (int)(l2 % this.blockSize);
        int n5 = n2;
        long l4 = l3;
        while (n5 > 0) {
            int n6 = Math.min(n5, (int)this.blockSize - n4);
            l4 = CRC64.updateChecksum(l4, this.blocks[n3], n4, n6);
            n5 -= n6;
            ++n3;
            n4 = 0;
        }
        return l4;
    }

    @Override
    final char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        String string = this.getString(l2, n2, characterSet);
        char[] cArray = string.toCharArray();
        nArray[0] = cArray.length;
        return cArray;
    }

    @Override
    final String getString(long l2, int n2, CharacterSet characterSet) throws SQLException {
        switch (characterSet.getOracleId()) {
            case 1: {
                return this.getStringFromUS7ASCII(l2, n2);
            }
            case 2: {
                return this.getStringFrom1Byte(l2, n2, WE8DEC_TO_JAVA);
            }
            case 31: {
                return this.getStringFrom1Byte(l2, n2, ISO_LATIN_1_TO_JAVA);
            }
            case 178: {
                return this.getStringFrom1Byte(l2, n2, WE8MSWIN1252_TO_JAVA);
            }
            case 2000: {
                return this.getStringFromAL16UTF16(l2, n2);
            }
            case 2002: {
                return this.getStringFromAL16UTF16LE(l2, n2);
            }
            case 871: {
                return this.getStringFromUTF8(l2, n2);
            }
            case 873: {
                return this.getStringFromAL32UTF8(l2, n2);
            }
        }
        assert (false) : "charSet: " + characterSet.toString();
        int n3 = (int)(l2 / this.blockSize);
        int n4 = (int)(l2 % this.blockSize);
        if (n2 <= (int)this.blockSize - n4) {
            return characterSet.toString(this.blocks[n3], n4, n2);
        }
        byte[] byArray = this.get(l2, n2);
        return characterSet.toString(byArray, 0, byArray.length);
    }

    private final String getStringFromUS7ASCII(long l2, int n2) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        int n3 = (int)(l2 / this.blockSize);
        int n4 = (int)(l2 % this.blockSize);
        byte[] byArray = null;
        int n5 = n2;
        char[] cArray = new char[n2];
        int n6 = 0;
        while (n5 > 0) {
            byArray = this.blocks[n3++];
            int n7 = Math.min(n4 + n5, byArray.length);
            n5 = n5 - n7 + n4;
            while (n4 < n7) {
                cArray[n6++] = (char)byArray[n4++];
            }
            n4 = 0;
        }
        assert (n6 == cArray.length) : "charIndex: " + n6 + "\tchars.length: " + cArray.length;
        return new String(cArray);
    }

    private static final char[] intToChar(int[] nArray) {
        char[] cArray = new char[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            cArray[i2] = (char)nArray[i2];
        }
        return cArray;
    }

    private final String getStringFrom1Byte(long l2, int n2, char[] cArray) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        int n3 = (int)(l2 / this.blockSize);
        int n4 = (int)(l2 % this.blockSize);
        byte[] byArray = null;
        int n5 = n2;
        char[] cArray2 = new char[n2];
        int n6 = 0;
        while (n5 > 0) {
            byArray = this.blocks[n3++];
            int n7 = Math.min(n4 + n5, byArray.length);
            n5 = n5 - n7 + n4;
            while (n4 < n7) {
                cArray2[n6++] = cArray[byArray[n4++] & 0xFF];
            }
            n4 = 0;
        }
        assert (n6 == cArray2.length) : "charIndex: " + n6 + "\tchars.length: " + cArray2.length;
        return new String(cArray2);
    }

    private final void setGlobals(long l2, int n2) {
        this.globalBlockIndex = (int)(l2 / this.blockSize);
        this.globalByteIndex = (int)(l2 % this.blockSize);
        this.globalRemaining = n2;
        this.globalBlockSize = (int)this.blockSize;
        this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
    }

    private final byte next() {
        assert (this.globalRemaining > 0) : "next overrun in DBA";
        byte by = this.globalBytes[this.globalByteIndex++];
        --this.globalRemaining;
        if (this.globalByteIndex >= this.globalBlockSize) {
            this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
            this.globalByteIndex = 0;
        }
        return by;
    }

    private final byte peek() {
        assert (this.globalRemaining > 0) : "peek overrun in DBA";
        return this.globalBytes[this.globalByteIndex];
    }

    private final void back() {
        if (this.globalByteIndex == 0) {
            this.globalByteIndex = this.globalBlockSize;
            --this.globalBlockIndex;
            this.globalBytes = this.blocks[this.globalBlockIndex];
        }
        --this.globalByteIndex;
        ++this.globalRemaining;
    }

    private final String getStringFromAL16UTF16(long l2, int n2) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        assert (n2 % 2 == 0) : "lengthInBytes: " + n2;
        this.setGlobals(l2, n2);
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        while (this.globalRemaining > 0) {
            int n4 = this.next() << 8;
            cArray[n3++] = (char)(n4 | this.next() & 0xFF);
        }
        assert (n3 == cArray.length) : "charIndex: " + n3 + "\tchars.length: " + cArray.length;
        return new String(cArray);
    }

    private final String getStringFromAL16UTF16LE(long l2, int n2) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        assert (n2 % 2 == 0) : "lengthInBytes: " + n2;
        this.setGlobals(l2, n2);
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        while (this.globalRemaining > 0) {
            byte by = this.next();
            int n4 = this.next() << 8 | by & 0xFF;
            if (!this.isHiSurrogate((char)n4)) {
                cArray[n3++] = n4;
                continue;
            }
            if (this.globalRemaining == 0) {
                cArray[n3++] = 65533;
                break;
            }
            by = this.next();
            char c2 = (char)(this.next() << 8 | by & 0xFF);
            cArray[n3++] = this.isLoSurrogate(c2) ? n4 : 65533;
            cArray[n3++] = c2;
        }
        assert (n3 == cArray.length) : "charIndex: " + n3 + "\tchars.length: " + cArray.length;
        return new String(cArray);
    }

    private final String getStringFromUTF8(long l2, int n2) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        this.setGlobals(l2, n2);
        int n3 = (int)((l2 + (long)n2 - 1L) / this.blockSize) + 1;
        int n4 = (int)((l2 + (long)n2 - 1L) % this.blockSize) + 1;
        char[] cArray = new char[n2];
        int n5 = 0;
        while (this.globalRemaining > 0) {
            char c2;
            byte by;
            int n6;
            byte by2 = this.next();
            if (by2 >= 0) {
                cArray[n5++] = (char)by2;
                n6 = this.globalBlockIndex == n3 ? n4 : (this.globalBlockIndex < n3 ? (int)this.blockSize : 0);
                for (by = this.globalByteIndex; by < n6 && (by2 = this.globalBytes[by]) >= 0; ++by) {
                    cArray[n5++] = (char)by2;
                }
                this.globalRemaining -= by - this.globalByteIndex;
                this.globalByteIndex = by;
                if (this.globalByteIndex < this.globalBlockSize) continue;
                this.globalByteIndex = 0;
                this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                continue;
            }
            int n7 = by2 & 0xF0;
            byte by3 = by2;
            if ((by3 = (byte)(by3 << 2)) >= 0) {
                if (this.globalRemaining < 1) {
                    cArray[n5++] = 65533;
                    continue;
                }
                c2 = this.conv2ByteUTFtoUTF16(by2, this.next());
                cArray[n5++] = c2;
                continue;
            }
            if ((by3 = (byte)(by3 << 1)) >= 0) {
                if (this.globalRemaining < 2) {
                    cArray[n5++] = 65533;
                    continue;
                }
                n6 = this.next();
                int n8 = this.conv3ByteUTFtoUTF16(by2, (byte)n6, by = (byte)this.next());
                if (this.isHiSurrogate((char)n8) && this.globalRemaining > 0) {
                    by2 = this.peek();
                    if ((byte)(by2 & 0xF0) != -32) {
                        cArray[n5++] = 65533;
                        continue;
                    }
                    this.next();
                    if (this.globalRemaining < 2) {
                        cArray[n5++] = 65533;
                        continue;
                    }
                    n6 = this.next();
                    c2 = this.conv3ByteUTFtoUTF16(by2, (byte)n6, by = this.next());
                    cArray[n5++] = this.isLoSurrogate(c2) ? n8 : 65533;
                    cArray[n5++] = c2;
                    continue;
                }
                cArray[n5++] = n8;
                continue;
            }
            cArray[n5++] = 65533;
        }
        return new String(cArray, 0, n5);
    }

    private final String getStringFromAL32UTF8(long l2, int n2) throws SQLException {
        assert (l2 >= 0L && n2 >= 0 && this.length >= l2 + (long)n2) : "this.length: " + this.length + " offset: " + l2 + " lengthInBytes: " + n2;
        this.setGlobals(l2, n2);
        int n3 = (int)((l2 + (long)n2 - 1L) / this.blockSize) + 1;
        int n4 = (int)((l2 + (long)n2 - 1L) % this.blockSize) + 1;
        char[] cArray = new char[n2];
        int n5 = 0;
        while (this.globalRemaining > 0) {
            byte by = this.next();
            if (by >= 0) {
                int n6;
                cArray[n5++] = (char)by;
                int n7 = this.globalBlockIndex == n3 ? n4 : (this.globalBlockIndex < n3 ? (int)this.blockSize : 0);
                for (n6 = this.globalByteIndex; n6 < n7 && (by = this.globalBytes[n6]) >= 0; ++n6) {
                    cArray[n5++] = (char)by;
                }
                this.globalRemaining -= n6 - this.globalByteIndex;
                this.globalByteIndex = n6;
                if (this.globalByteIndex < this.globalBlockSize) continue;
                this.globalByteIndex = 0;
                this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                continue;
            }
            byte by2 = by;
            if ((by2 = (byte)(by2 << 2)) >= 0) {
                if (this.globalRemaining < 1) {
                    cArray[n5++] = 65533;
                    continue;
                }
                cArray[n5++] = this.conv2ByteUTFtoUTF16(by, this.next());
                continue;
            }
            if ((by2 = (byte)(by2 << 1)) >= 0) {
                if (this.globalRemaining < 2) {
                    cArray[n5++] = 65533;
                    continue;
                }
                cArray[n5++] = this.conv3ByteAL32UTF8toUTF16(by, this.next(), this.next());
                continue;
            }
            if ((by2 = (byte)(by2 << 1)) >= 0) {
                if (this.globalRemaining < 3) {
                    cArray[n5++] = 65533;
                    continue;
                }
                n5 = this.conv4ByteAL32UTF8toUTF16(by, this.next(), this.next(), this.next(), cArray, n5);
                continue;
            }
            cArray[n5++] = 65533;
        }
        return new String(cArray, 0, n5);
    }

    private final boolean isHiSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\ud800';
    }

    private final boolean isLoSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\udc00';
    }

    private final boolean check80toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128;
    }

    private final boolean check80to8F(byte by) {
        return (by & 0xFFFFFFF0) == -128;
    }

    private final boolean check80to9F(byte by) {
        return (by & 0xFFFFFFE0) == -128;
    }

    private final boolean checkA0toBF(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    private final boolean check90toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128 && (by & 0x30) != 0;
    }

    private final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        if (by < -62 || by > -33 || !this.check80toBF(by2)) {
            this.back();
            return '\ufffd';
        }
        return (char)((by & 0x1F) << 6 | by2 & 0x3F);
    }

    private final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && this.checkA0toBF(by2) && this.check80toBF(by3) || by >= -31 && by <= -17 && this.check80toBF(by2) && this.check80toBF(by3))) {
            this.back();
            this.back();
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    private final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && this.checkA0toBF(by2) && this.check80toBF(by3) || by >= -31 && by <= -20 && this.check80toBF(by2) && this.check80toBF(by3) || by == -19 && this.check80to9F(by2) && this.check80toBF(by3) || by >= -18 && by <= -17 && this.check80toBF(by2) && this.check80toBF(by3))) {
            this.back();
            this.back();
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    private final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n2) {
        boolean bl = false;
        if (!(by == -16 && this.check90toBF(by2) && this.check80toBF(by3) && this.check80toBF(by4) || by >= -15 && by <= -13 && this.check80toBF(by2) && this.check80toBF(by3) && this.check80toBF(by4) || by == -12 && this.check80to8F(by2) && this.check80toBF(by3) && this.check80toBF(by4))) {
            this.back();
            this.back();
            this.back();
            cArray[n2++] = 65533;
        } else {
            cArray[n2++] = (char)((((by & 7) << 2 | by2 >>> 4 & 3) - 1 & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >>> 4 & 3 | 0xD800);
            cArray[n2++] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
        }
        return n2;
    }

    @Override
    byte[] getBlockBasic(long l2, int[] nArray) {
        int n2 = (int)(l2 / this.blockSize);
        nArray[0] = (int)(l2 % this.blockSize);
        if (n2 >= this.blocks.length) {
            return null;
        }
        return this.blocks[n2];
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 6);
        for (char c2 : string.toCharArray()) {
            stringBuilder.append("\\u");
            byte by = (byte)(c2 >> 8);
            String string2 = "00" + Integer.toHexString(by & 0xFF);
            stringBuilder.append(string2, string2.length() - 2, string2.length());
            string2 = "00" + Integer.toHexString((byte)c2 & 0xFF);
            stringBuilder.append(string2, string2.length() - 2, string2.length());
        }
        return stringBuilder.toString();
    }

    static {
        final char[][] cArrayArray = new char[3][];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JdbcCharacterConverters jdbcCharacterConverters = CharacterConverterJDBC.getInstance(31);
                cArrayArray[0] = DynamicByteArray.intToChar(((CharacterConverter1Byte)jdbcCharacterConverters).m_ucsChar);
                jdbcCharacterConverters = CharacterConverterJDBC.getInstance(2);
                cArrayArray[1] = DynamicByteArray.intToChar(((CharacterConverter1Byte)jdbcCharacterConverters).m_ucsChar);
                jdbcCharacterConverters = CharacterConverterJDBC.getInstance(178);
                cArrayArray[2] = DynamicByteArray.intToChar(((CharacterConverter1Byte)jdbcCharacterConverters).m_ucsChar);
                return null;
            }
        });
        ISO_LATIN_1_TO_JAVA = cArrayArray[0];
        WE8DEC_TO_JAVA = cArrayArray[1];
        WE8MSWIN1252_TO_JAVA = cArrayArray[2];
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

