/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.rules;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.rules.HFrRule;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findParamsForRule", query=" from HFrRuleParam ptable  where ptable.rule = :rule  order by id ASC"), @NamedQuery(name="findParamByNameForRule", query=" from HFrRuleParam ptable  where ptable.rule = :rule  AND ptable.name = :paramName  order by id ASC"), @NamedQuery(name="findOutputParamsForRule", query=" from HFrRuleParam ptable  where ptable.rule = :rule  AND ptable.type=:paramType  order by id ASC")})
@Table(name="HFR_RULE_PARAM")
public class HFrRuleParam
extends HOwneredEntity {
    private HFrRule rule;
    private String type;
    private String name;
    private Integer operatorId;
    private String key;
    private String value;
    private Long deleteId;

    public HFrRuleParam() {
        this.operatorId = 0;
    }

    public HFrRuleParam(HFrRuleParam param) {
        this.type = param.getType();
        this.name = param.getName();
        this.operatorId = param.getOperatorId();
        this.key = param.getKey();
        this.value = param.getValue();
    }

    @ManyToOne(targetEntity=HFrRule.class)
    @JoinColumn(name="RULE_ID")
    @Index(name="RULE_ID_IDX")
    public HFrRule getRule() {
        return this.rule;
    }

    @Column(name="`TYPE`", nullable=false)
    public String getType() {
        return this.type;
    }

    @Column(name="NAME", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="OPERATOR_ID", nullable=false)
    public Integer getOperatorId() {
        return this.operatorId;
    }

    @Column(name="`KEY`", nullable=false, length=200)
    public String getKey() {
        return this.key;
    }

    @Column(name="`VALUE`", length=2000)
    public String getValue() {
        return this.value;
    }

    @Transient
    public Long getDeleteId() {
        return this.deleteId;
    }

    @Transient
    public String getOperatorIdStr() {
        return this.operatorId + "";
    }

    @Transient
    public String getDnxSection() {
        return this.key.substring(1, this.key.length() - 1).split(",")[0].trim();
    }

    @Transient
    public String getDnxSectionKey() {
        return this.key.substring(1, this.key.length() - 1).split(",")[1].trim();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRule(HFrRule frRule) {
        this.rule = frRule;
    }

    public void setOperatorId(Integer opId) {
        this.operatorId = opId;
    }

    public void setKey(String name) {
        this.key = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeleteId(Long deleteId) {
        this.deleteId = deleteId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleteId == null ? 0 : this.deleteId.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.operatorId == null ? 0 : this.operatorId.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFrRuleParam other = (HFrRuleParam)obj;
        if (this.deleteId == null ? other.deleteId != null : !this.deleteId.equals(other.deleteId)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.operatorId == null ? other.operatorId != null : !this.operatorId.equals(other.operatorId)) {
            return false;
        }
        if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

