/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.GeneralTextChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.RepInfo;

public class TextChunk
extends GeneralTextChunk {
    public TextChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        StringBuilder sb = new StringBuilder();
        String keyword = null;
        String value = null;
        int i = 0;
        while ((long)i < this.length) {
            int c = this.readUnsignedByte();
            if (c == 0) {
                if (keyword != null) {
                    ErrorMessage msg = new ErrorMessage("Unexpected null in tEXt chunk");
                    info.setMessage(msg);
                    info.setWellFormed(false);
                    throw new PNGException("Bad tEXt chunk");
                }
                keyword = sb.toString();
                sb = new StringBuilder();
            } else {
                sb.append((char)c);
            }
            ++i;
        }
        if (keyword != null) {
            value = sb.toString();
        }
        this._module.addKeyword(keyword, value);
    }
}

