/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.schema;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class DBSchemaUtil {
    private static final ExLogger log = ExLogger.getExLogger(DBSchemaUtil.class);
    public static String SHR_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.shr.username");
    public static String DEP_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.dep.username");
    public static String REP_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.rep.username");
    public static String PRSV_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.prsv.username");
    public static String PUB_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.pub.username");
    public static String PER_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.per.username");
    public static String RPT_SCHEMA;
    public static String JBPM_SCHEMA;

    public static Connection getConnection(String schemaUsername) {
        Connection connection = null;
        try {
            String connectionUrl = GlobalProperties.getInstance().getProperty("dbconnection.url");
            connection = DriverManager.getConnection(connectionUrl, schemaUsername, DBSchemaUtil.getPassword(schemaUsername));
        }
        catch (SQLException e) {
            log.error("Failed to set connection", e, new String[0]);
        }
        return connection;
    }

    private static String getPassword(String schemaUsername) {
        String result = schemaUsername;
        ExecExternalProcess proc = new ExecExternalProcess();
        int exitValue = proc.execExternalProcess("get_ora_passwd", Arrays.asList(schemaUsername));
        if (exitValue == 0) {
            result = proc.getInputStream();
        } else {
            String output = StringUtils.isNotBlank((String)proc.getErrorStream()) ? proc.getErrorStream() : proc.getInputStream();
            log.error("Failed to get password :" + output, new String[0]);
        }
        return result;
    }

    static {
        JBPM_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.jbpm.username");
        RPT_SCHEMA = GlobalProperties.getInstance().getProperty("dbconnection.rpt.username");
    }
}

