/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.tools;

import com.exlibris.core.infra.model.properties.PropertiesConfiguration;
import java.util.LinkedList;
import java.util.List;

public class SearchFacetObject {
    private PropertiesConfiguration.Facet type;
    private Integer limit;
    private List<SearchFacetValue> values = new LinkedList<SearchFacetValue>();

    public PropertiesConfiguration.Facet getType() {
        return this.type;
    }

    public void setType(PropertiesConfiguration.Facet type) {
        this.type = type;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public List<SearchFacetValue> getValues() {
        return this.values;
    }

    public void setValues(List<SearchFacetValue> values) {
        this.values = values;
    }

    public void put(String value, String label, Long count) {
        this.values.add(new SearchFacetValue(value, label, count));
    }

    public void setValuesOnly(String[] valuesOnly) {
        if (this.values == null) {
            return;
        }
        for (String value : valuesOnly) {
            this.values.add(new SearchFacetValue(value, null, null));
        }
    }

    public String[] getValuesOnly() {
        return this.getValuesLimited(null);
    }

    public String[] getValuesLimited(String limit) {
        String[] valuesOnly = new String[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            valuesOnly[i] = (limit != null ? limit : "") + this.values.get(i).getValue() + (limit != null ? limit : "");
        }
        return valuesOnly;
    }

    public String[][] getMultiValuesOnly() {
        String[][] valuesOnly = new String[this.values.size()][];
        for (int i = 0; i < this.values.size(); ++i) {
            valuesOnly[i] = this.values.get(i).getValues();
        }
        return valuesOnly;
    }

    public class SearchFacetValue {
        public final String VALUE_SEPARATOR = "\\|";
        private String value;
        private String[] values;
        private String label;
        private Long count;

        SearchFacetValue() {
            this.value = "";
            this.label = "";
            this.count = null;
        }

        public SearchFacetValue(String value, String label, Long count) {
            this.setValue(value);
            this.label = label;
            this.count = count;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            if (value != null) {
                this.values = value.split("\\|");
            }
        }

        public String[] getValues() {
            return this.values;
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

